/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIAttackMeleeTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIWanderHuntArea;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ParametersAreNonnullByDefault
public class EntityPantherTFC
extends EntityAnimalMammal
implements IPredator {
    private static final int DAYS_TO_ADULTHOOD = 160;

    public EntityPantherTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityPantherTFC.getRandomGrowth(160, 0));
    }

    public EntityPantherTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(1.1f, 1.1f);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!BiomesTFC.isOceanicBiome(biome) && !BiomesTFC.isBeachBiome(biome) && biomeType == BiomeHelper.BiomeType.TROPICAL_FOREST) {
            return ConfigTFC.Animals.PANTHER.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getDaysToAdulthood() {
        return 160;
    }

    @Override
    public int getDaysToElderly() {
        return 0;
    }

    @Override
    public void birthChildren() {
    }

    @Override
    public long gestationDays() {
        return 0L;
    }

    @Override
    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    public double getOldDeathChance() {
        return 0.0;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_PANTHER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_PANTHER_DEATH;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        double attackDamage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.func_70631_g_()) {
            attackDamage /= 2.0;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)attackDamage)) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void func_184651_r() {
        EntityAIWanderHuntArea wander = new EntityAIWanderHuntArea((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, new EntityAIAttackMeleeTFC<EntityPantherTFC>(this, 1.2, 1.25, EntityAIAttackMeleeTFC.AttackBehavior.NIGHTTIME_ONLY).setWanderAI(wander));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)wander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 1.0, 1.25));
        int priority = 2;
        for (String input : ConfigTFC.Animals.PANTHER.huntCreatures) {
            Class entityClass;
            ResourceLocation key = new ResourceLocation(input);
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
            if (entityEntry == null || !EntityLivingBase.class.isAssignableFrom(entityClass = entityEntry.getEntityClass())) continue;
            this.field_70715_bh.func_75776_a(priority++, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entityClass, false));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.38);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected SoundEvent func_184639_G() {
        return Constants.RNG.nextInt(100) < 5 ? TFCSounds.ANIMAL_PANTHER_CRY : TFCSounds.ANIMAL_PANTHER_SAY;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_PANTHER;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.func_110175_bO()) {
            this.func_175449_a(this.func_180425_c(), 80);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(TFCSounds.ANIMAL_FELINE_STEP, 0.14f, 1.1f);
    }
}

