/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIPanicTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityLlamaTFC
extends EntityLlama
implements IAnimalTFC,
ILivestock {
    protected static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityLlamaTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityLlamaTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityLlamaTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FERTILIZED = EntityDataManager.func_187226_a(EntityLlamaTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Long> PREGNANT_TIME = EntityDataManager.func_187226_a(EntityLlamaTFC.class, EntitiesTFC.getLongDataSerializer());
    protected long lastFed;
    protected long lastFDecay;
    protected long matingTime;
    protected long lastDeath;
    protected float geneJump;
    protected float geneHealth;
    protected float geneSpeed;
    protected float geneStrength;
    protected int geneVariant;

    public EntityLlamaTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(ConfigTFC.Animals.LLAMA.adulthood, ConfigTFC.Animals.LLAMA.elder));
    }

    public EntityLlamaTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.setFertilized(false);
        this.geneHealth = 0.0f;
        this.geneJump = 0.0f;
        this.geneSpeed = 0.0f;
        this.geneStrength = 0.0f;
        this.geneVariant = 0;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110207_m(false);
        }
        super.func_70645_a(cause);
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            boolean holdingChest = false;
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                holdingChest = itemBlock.func_179223_d() instanceof BlockChest;
            }
            if (stack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (!this.func_190695_dh() && this.func_110248_bS() && holdingChest) {
                this.func_110207_m(true);
                this.func_190697_dk();
                this.func_110226_cD();
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            if (this.isFood(stack) && player.func_70093_af() && this.getAdultFamiliarityCap() > 0.0f) {
                if (this.isHungry()) {
                    IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
                    if (cap != null && cap.isRotten()) {
                        return false;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
                        this.func_175505_a(player, stack);
                        if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                            float familiarity = this.getFamiliarity() + 0.06f;
                            if (this.getAge() != IAnimalTFC.Age.CHILD) {
                                familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                            }
                            this.setFamiliarity(familiarity);
                        }
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
                    }
                    return true;
                }
                if (!this.field_70170_p.field_72995_K && this.isFertilized() && this.getType() == IAnimalTFC.Type.MAMMAL) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.animal.mating.pregnant", new Object[]{this.func_70005_c_()}));
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.35f;
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return (Boolean)this.field_70180_af.func_187225_a(FERTILIZED);
    }

    @Override
    public void setFertilized(boolean value) {
        this.field_70180_af.func_187227_b(FERTILIZED, (Object)value);
    }

    @Override
    public void onFertilized(@Nonnull IAnimalTFC male) {
        this.setPregnantTime(CalendarTFC.PLAYER_TIME.getTotalDays());
        int selection = this.field_70146_Z.nextInt(9);
        int i = selection < 4 ? this.func_190719_dM() : (selection < 8 ? ((EntityLlamaTFC)male).func_190719_dM() : this.field_70146_Z.nextInt(4));
        this.geneVariant = i;
        EntityLlamaTFC father = (EntityLlamaTFC)male;
        this.geneHealth = (float)((father.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL()) / 3.0);
        this.geneSpeed = (float)((father.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN()) / 3.0);
        this.geneJump = (float)((father.func_110148_a(field_110271_bv).func_111125_b() + this.func_110148_a(field_110271_bv).func_111125_b() + this.func_110245_cM()) / 3.0);
        this.geneStrength = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), father.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            this.geneStrength += 1.0f;
        }
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.LLAMA.gestation;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.LLAMA.elder;
    }

    @Override
    public boolean isReadyToMate() {
        if (this.getAge() != IAnimalTFC.Age.ADULT || this.getFamiliarity() < 0.3f || this.isFertilized() || this.isHungry()) {
            return false;
        }
        return this.matingTime + 2000L <= CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TEMPERATE_FOREST && biomeType != BiomeHelper.BiomeType.TUNDRA)) {
            return ConfigTFC.Animals.LLAMA.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 2;
    }

    @Override
    public int getMaxGroupSize() {
        return 4;
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    protected void func_110237_h(EntityPlayer player) {
        if (this.getFamiliarity() > 0.15f) {
            super.func_110237_h(player);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.isFertilized() && CalendarTFC.PLAYER_TIME.getTotalDays() >= this.getPregnantTime() + this.gestationDays()) {
                this.birthChildren();
                this.setFertilized(false);
            }
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getGender() == IAnimalTFC.Gender.MALE && this.isReadyToMate()) {
                this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
                EntityAnimalTFC.findFemaleMate(this);
            }
            if (this.getAge() == IAnimalTFC.Age.OLD && this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
                Random random = new Random(this.field_96093_i.getMostSignificantBits() * CalendarTFC.PLAYER_TIME.getTotalDays());
                if (random.nextDouble() < ConfigTFC.Animals.LLAMA.oldDeathChance) {
                    this.func_70106_y();
                }
            }
        }
    }

    public long gestationDays() {
        return ConfigTFC.Animals.LLAMA.gestation;
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74757_a("fertilized", this.isFertilized());
        nbt.func_74772_a("mating", this.matingTime);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
        nbt.func_74772_a("pregnant", this.getPregnantTime());
        nbt.func_74776_a("geneSpeed", this.geneSpeed);
        nbt.func_74776_a("geneJump", this.geneJump);
        nbt.func_74776_a("geneHealth", this.geneHealth);
        nbt.func_74776_a("geneStrength", this.geneStrength);
        nbt.func_74768_a("geneVariant", this.geneVariant);
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.matingTime = nbt.func_74763_f("mating");
        this.setFertilized(nbt.func_74767_n("fertilized"));
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
        this.setPregnantTime(nbt.func_74763_f("pregnant"));
        this.geneSpeed = nbt.func_74760_g("geneSpeed");
        this.geneJump = nbt.func_74760_g("geneJump");
        this.geneHealth = nbt.func_74760_g("geneHealth");
        this.geneStrength = nbt.func_74760_g("geneStrength");
        this.geneVariant = nbt.func_74762_e("geneVariant");
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicTFC((EntityCreature)this, 1.4));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PREGNANT_TIME, (Object)-1L);
        this.func_184212_Q().func_187214_a(FERTILIZED, (Object)false);
    }

    protected boolean func_190678_b(EntityPlayer player, ItemStack stack) {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_LLAMA;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        EntityLlamaTFC other = (EntityLlamaTFC)otherAnimal;
        return this.getGender() != other.getGender() && this.func_70880_s() && other.func_70880_s();
    }

    @Nullable
    public EntityLlama func_90011_a(@Nonnull EntityAgeable other) {
        if (other != this && this.getGender() == IAnimalTFC.Gender.FEMALE && other instanceof IAnimalTFC) {
            this.setFertilized(true);
            this.func_70875_t();
            this.onFertilized((IAnimalTFC)other);
        } else if (other == this) {
            return new EntityLlamaTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
        }
        return null;
    }

    public void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.LLAMA.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            EntityLlamaTFC baby = new EntityLlamaTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (this.geneHealth > 0.0f) {
                baby.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.geneHealth);
            }
            if (this.geneSpeed > 0.0f) {
                baby.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.geneSpeed);
            }
            if (this.geneJump > 0.0f) {
                baby.func_110148_a(field_110271_bv).func_111128_a((double)this.geneJump);
            }
            if (this.geneStrength > 0.0f) {
                this.func_190706_p((int)this.geneStrength);
            }
            baby.func_190710_o(this.geneVariant);
            this.geneJump = 0.0f;
            this.geneSpeed = 0.0f;
            this.geneJump = 0.0f;
            this.geneStrength = 0.0f;
            this.geneVariant = 0;
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    public long getPregnantTime() {
        return (Long)this.field_70180_af.func_187225_a(PREGNANT_TIME);
    }

    public void setPregnantTime(long pregnantTime) {
        this.field_70180_af.func_187227_b(PREGNANT_TIME, (Object)pregnantTime);
    }
}

