/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.egg.CapabilityEgg;
import net.dries007.tfc.api.capability.egg.IEgg;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.EntityChickenTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityGrouseTFC
extends EntityChickenTFC
implements ILivestock {
    public EntityGrouseTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityGrouseTFC.getRandomGrowth(ConfigTFC.Animals.GROUSE.adulthood, ConfigTFC.Animals.GROUSE.elder));
    }

    public EntityGrouseTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.8f, 0.8f);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.PLAINS && biomeType != BiomeHelper.BiomeType.SAVANNA)) {
            return ConfigTFC.Animals.GROUSE.rarity;
        }
        return 0;
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.GROUSE.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.GROUSE.elder;
    }

    @Override
    public List<ItemStack> getProducts() {
        IEgg cap;
        ArrayList<ItemStack> eggs = new ArrayList<ItemStack>();
        ItemStack egg = new ItemStack(Items.field_151110_aK);
        if (this.isFertilized() && (cap = (IEgg)egg.getCapability(CapabilityEgg.CAPABILITY, null)) != null) {
            EntityGrouseTFC chick = new EntityGrouseTFC(this.field_70170_p);
            chick.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            cap.setFertilized((Entity)chick, (long)ConfigTFC.Animals.GROUSE.hatch + CalendarTFC.PLAYER_TIME.getTotalDays());
        }
        eggs.add(egg);
        return eggs;
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)ConfigTFC.Animals.GROUSE.eggTicks + this.getLaidTicks() - CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_GROUSE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_GROUSE_DEATH;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return TFCSounds.ANIMAL_GROUSE_SAY;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_GROUSE;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Override
    public double getOldDeathChance() {
        return ConfigTFC.Animals.GROUSE.oldDeathChance;
    }
}

