/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IHuntable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityGazelleTFC
extends EntityAnimalMammal
implements IHuntable {
    private static final int DAYS_TO_ADULTHOOD = 128;

    public EntityGazelleTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityGazelleTFC.getRandomGrowth(128, 0));
    }

    public EntityGazelleTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(1.0f, 1.5f);
    }

    @Override
    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    public double getOldDeathChance() {
        return 0.0;
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.PLAINS && biomeType != BiomeHelper.BiomeType.SAVANNA)) {
            return ConfigTFC.Animals.GAZELLE.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 3;
    }

    @Override
    public int getMaxGroupSize() {
        return 5;
    }

    @Override
    public void birthChildren() {
    }

    @Override
    public long gestationDays() {
        return 0L;
    }

    @Override
    public int getDaysToAdulthood() {
        return 128;
    }

    @Override
    public int getDaysToElderly() {
        return 0;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_DEER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_DEER_DEATH;
    }

    protected void func_184651_r() {
        double speedMult = 1.4;
        EntityAnimalTFC.addWildPreyAI(this, speedMult);
        EntityAnimalTFC.addCommonPreyAI(this, speedMult);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.1, (Item)ItemsTFC.SALT, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIEatGrass((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.33);
    }

    protected SoundEvent func_184639_G() {
        return TFCSounds.ANIMAL_GAZELLE_SAY;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_GAZELLE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.14f, 0.8f);
    }
}

