/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIAttackMeleeTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIWanderHuntArea;
import net.dries007.tfc.objects.entity.animal.EntityPantherTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ParametersAreNonnullByDefault
public class EntityCougarTFC
extends EntityPantherTFC
implements IPredator {
    private static final int DAYS_TO_ADULTHOOD = 160;

    public EntityCougarTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityCougarTFC.getRandomGrowth(160, 0));
    }

    public EntityCougarTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(1.1f, 1.1f);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!BiomesTFC.isOceanicBiome(biome) && !BiomesTFC.isBeachBiome(biome) && biomeType == BiomeHelper.BiomeType.TEMPERATE_FOREST) {
            return ConfigTFC.Animals.COUGAR.rarity;
        }
        return 0;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_COUGAR_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_COUGAR_DEATH;
    }

    @Override
    protected void func_184651_r() {
        EntityAIWanderHuntArea wander = new EntityAIWanderHuntArea((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, new EntityAIAttackMeleeTFC<EntityCougarTFC>(this, 1.2, 1.25, EntityAIAttackMeleeTFC.AttackBehavior.NIGHTTIME_ONLY).setWanderAI(wander));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)wander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 1.0, 1.25));
        int priority = 2;
        for (String input : ConfigTFC.Animals.COUGAR.huntCreatures) {
            Class entityClass;
            ResourceLocation key = new ResourceLocation(input);
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
            if (entityEntry == null || !EntityLivingBase.class.isAssignableFrom(entityClass = entityEntry.getEntityClass())) continue;
            this.field_70715_bh.func_75776_a(priority++, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entityClass, false));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return Constants.RNG.nextInt(100) < 5 ? TFCSounds.ANIMAL_COUGAR_CRY : TFCSounds.ANIMAL_COUGAR_SAY;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_COUGAR;
    }
}

