/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ICreatureTFC;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIPanicTFC;
import net.dries007.tfc.objects.entity.ai.EntityAITamableAvoidPlayer;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.objects.entity.animal.EntityWolfTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class EntityAnimalTFC
extends EntityAnimal
implements IAnimalTFC {
    public static final long MATING_COOLDOWN_DEFAULT_TICKS = 2000L;
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityAnimalTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityAnimalTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityAnimalTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FERTILIZED = EntityDataManager.func_187226_a(EntityAnimalTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private long lastFed;
    private long lastFDecay;
    private long matingTime;
    private long lastDeath;

    public static int getRandomGrowth(int daysToAdult, int daysToElder) {
        int randomFactor = daysToElder > 0 ? (int)((float)daysToElder * 1.25f) : daysToAdult * 4;
        int lifeTimeDays = daysToAdult + Constants.RNG.nextInt(randomFactor);
        return (int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays);
    }

    public static <T extends EntityAnimal> void findFemaleMate(T maleAnimal) {
        List list = maleAnimal.field_70170_p.func_72872_a(maleAnimal.getClass(), maleAnimal.func_174813_aQ().func_186662_g(8.0));
        for (EntityAnimal femaleAnimal : list) {
            IAnimalTFC female = (IAnimalTFC)femaleAnimal;
            if (female.getGender() != IAnimalTFC.Gender.FEMALE || femaleAnimal.func_70880_s() || !female.isReadyToMate()) continue;
            femaleAnimal.func_146082_f(null);
            maleAnimal.func_146082_f(null);
            break;
        }
    }

    public static <T extends EntityAnimal> void addCommonLivestockAI(T entity, double speedMult) {
        entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate(entity, 1.0));
        for (ItemStack is : OreDictionary.getOres((String)"grain")) {
            Item item = is.func_77973_b();
            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt(entity, 1.1, item, false));
        }
        double farSpeed = 0.8 * speedMult;
        double nearSpeed = 1.1 * speedMult;
        entity.field_70714_bg.func_75776_a(4, new EntityAITamableAvoidPlayer<T>(entity, 6.0f, farSpeed, nearSpeed));
        entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIEatGrass(entity));
    }

    public static void addWildPreyAI(EntityAnimal entity, double speedMult) {
        double farSpeed = 0.8 * speedMult;
        double nearSpeed = 1.1 * speedMult;
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityPlayer.class, 12.0f, farSpeed, nearSpeed));
    }

    public static void addCommonPreyAI(EntityAnimal entity, double speedMult) {
        double farSpeed = 0.8 * speedMult;
        double nearSpeed = 1.1 * speedMult;
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicTFC((EntityCreature)entity, 1.4 * speedMult));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityWolfTFC.class, 8.0f, farSpeed, nearSpeed));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityAnimalMammal.class, Predicates.instanceOf(IPredator.class), 12.0f, farSpeed, nearSpeed));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityMob.class, 8.0f, farSpeed * 0.7, nearSpeed * 0.7));
        entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)entity, 1.0));
        entity.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPlayer.class, 6.0f));
        entity.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
    }

    public EntityAnimalTFC(World worldIn) {
        super(worldIn);
    }

    public EntityAnimalTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.setFertilized(false);
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return (Boolean)this.field_70180_af.func_187225_a(FERTILIZED);
    }

    @Override
    public void setFertilized(boolean value) {
        this.field_70180_af.func_187227_b(FERTILIZED, (Object)value);
    }

    @Override
    public boolean isReadyToMate() {
        if (this.getAge() != IAnimalTFC.Age.ADULT || this.getFamiliarity() < 0.3f || this.isFertilized() || this.isHungry()) {
            return false;
        }
        return this.matingTime + 2000L <= CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable other) {
        if (other != this && this.getGender() == IAnimalTFC.Gender.FEMALE && other instanceof IAnimalTFC) {
            this.setFertilized(true);
            this.func_70875_t();
            this.onFertilized((IAnimalTFC)other);
        } else if (other == this) {
            try {
                EntityAnimalTFC baby = (EntityAnimalTFC)this.getClass().getConstructor(World.class).newInstance(this.field_70170_p);
                baby.setGender(IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()));
                baby.setBirthDay((int)CalendarTFC.PLAYER_TIME.getTotalDays());
                baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
                return baby;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(FERTILIZED, (Object)false);
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getType() != IAnimalTFC.Type.OVIPAROUS) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getGender() == IAnimalTFC.Gender.MALE && this.isReadyToMate()) {
                this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
                EntityAnimalTFC.findFemaleMate(this);
            }
            if (this.getAge() == IAnimalTFC.Age.OLD && this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
                Random random = new Random(this.field_96093_i.getMostSignificantBits() * CalendarTFC.PLAYER_TIME.getTotalDays());
                if (random.nextDouble() < this.getOldDeathChance()) {
                    this.func_70106_y();
                }
            }
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74757_a("fertilized", this.isFertilized());
        nbt.func_74772_a("mating", this.matingTime);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.matingTime = nbt.func_74763_f("mating");
        this.setFertilized(nbt.func_74767_n("fertilized"));
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (this.isFood(itemstack) && player.func_70093_af() && this.getCreatureType() == ICreatureTFC.CreatureType.LIVESTOCK) {
                if (this.isHungry()) {
                    return this.eatFood(itemstack, player);
                }
                if (!this.field_70170_p.field_72995_K && this.isFertilized() && this.getType() == IAnimalTFC.Type.MAMMAL) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.animal.mating.pregnant", new Object[]{this.func_70005_c_()}));
                }
            }
        }
        return false;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        EntityAnimalTFC other = (EntityAnimalTFC)otherAnimal;
        return this.getGender() != other.getGender() && this.func_70880_s() && other.func_70880_s();
    }

    public abstract double getOldDeathChance();

    protected boolean eatFood(@Nonnull ItemStack stack, EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
            this.func_175505_a(player, stack);
            if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                float familiarity = this.getFamiliarity() + 0.06f;
                if (this.getAge() != IAnimalTFC.Age.CHILD) {
                    familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                }
                this.setFamiliarity(familiarity);
            }
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
            TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
        }
        return true;
    }
}

