/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.entity.EntityLiving;

public enum AnimalGroupingRules implements BiConsumer<List<EntityLiving>, Random>
{
    MOTHER_AND_CHILDREN_OR_SOLO_MALE{

        @Override
        public void accept(List<EntityLiving> entityLivings, Random random) {
            for (int i = 0; i < entityLivings.size(); ++i) {
                int lifeTimeDays;
                EntityLiving living = entityLivings.get(i);
                if (!(living instanceof IAnimalTFC)) continue;
                IAnimalTFC animal = (IAnimalTFC)living;
                if (i == 0) {
                    lifeTimeDays = 1 + (int)Math.ceil((double)animal.getDaysToAdulthood() + (double)animal.getDaysToElderly() * (0.05 + random.nextDouble()));
                    animal.setGender(entityLivings.size() > 1 ? IAnimalTFC.Gender.FEMALE : IAnimalTFC.Gender.MALE);
                    animal.setBirthDay((int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays));
                    continue;
                }
                lifeTimeDays = random.nextInt(animal.getDaysToAdulthood());
                animal.setGender(IAnimalTFC.Gender.valueOf(random.nextBoolean()));
                animal.setBirthDay((int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays));
            }
        }
    }
    ,
    ELDER_AND_POPULATION{

        @Override
        public void accept(List<EntityLiving> entityLivings, Random random) {
            for (int i = 0; i < entityLivings.size(); ++i) {
                EntityLiving living = entityLivings.get(i);
                if (!(living instanceof IAnimalTFC)) continue;
                IAnimalTFC animal = (IAnimalTFC)living;
                if (i == 0) {
                    int lifeTimeDays = 1 + (int)Math.ceil((double)animal.getDaysToAdulthood() + (double)animal.getDaysToElderly() * (0.33 + random.nextDouble()));
                    animal.setGender(IAnimalTFC.Gender.valueOf(random.nextBoolean()));
                    animal.setBirthDay((int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays));
                    continue;
                }
                double growth = Math.pow(random.nextDouble(), 0.5);
                double maxLifetime = 1.0 + (double)animal.getDaysToAdulthood() * 1.25 + (double)animal.getDaysToElderly();
                int lifeTimeDays = (int)(maxLifetime * growth);
                animal.setGender(IAnimalTFC.Gender.FEMALE);
                animal.setBirthDay((int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays));
            }
        }
    }
    ,
    MALE_AND_FEMALES{

        @Override
        public void accept(List<EntityLiving> entityLivings, Random random) {
            for (int i = 0; i < entityLivings.size(); ++i) {
                EntityLiving living = entityLivings.get(i);
                if (!(living instanceof IAnimalTFC)) continue;
                IAnimalTFC animal = (IAnimalTFC)living;
                if (i == 0) {
                    int lifeTimeDays = 1 + (int)Math.ceil((double)animal.getDaysToAdulthood() + (double)animal.getDaysToElderly() * (0.2 + random.nextDouble()));
                    animal.setGender(IAnimalTFC.Gender.MALE);
                    animal.setBirthDay((int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays));
                    continue;
                }
                double growth = Math.pow(random.nextDouble(), 0.5);
                double maxLifetime = 1.0 + (double)animal.getDaysToAdulthood() * 1.25 + (double)animal.getDaysToElderly();
                int lifeTimeDays = (int)(maxLifetime * growth);
                animal.setGender(IAnimalTFC.Gender.FEMALE);
                animal.setBirthDay((int)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)lifeTimeDays));
            }
        }
    };

}

