/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.objects.container.ContainerItemStack;
import net.dries007.tfc.objects.container.IButtonHandler;
import net.dries007.tfc.objects.inventory.slot.SlotKnappingOutput;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SimpleCraftMatrix;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class ContainerKnapping
extends ContainerItemStack
implements IButtonHandler {
    private final SimpleCraftMatrix matrix;
    private final KnappingType type;
    private final ItemStack stackCopy;
    public boolean requiresReset;
    private boolean hasBeenModified;

    public ContainerKnapping(KnappingType type, InventoryPlayer playerInv, ItemStack stack) {
        super(playerInv, stack);
        ++this.itemIndex;
        this.type = type;
        this.stackCopy = this.stack.func_77946_l();
        this.matrix = new SimpleCraftMatrix();
        this.hasBeenModified = false;
        this.requiresReset = false;
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable NBTTagCompound extraNBT) {
        Slot slot;
        this.matrix.set(buttonID, false);
        if (!this.hasBeenModified) {
            if (!this.player.func_184812_l_() && !this.type.consumeAfterComplete()) {
                ItemStack consumedStack = Helpers.consumeItem(this.stack, this.type.getAmountToConsume());
                if (this.isOffhand) {
                    this.player.func_184611_a(EnumHand.OFF_HAND, consumedStack);
                } else {
                    this.player.func_184611_a(EnumHand.MAIN_HAND, consumedStack);
                }
            }
            this.hasBeenModified = true;
        }
        if ((slot = (Slot)this.field_75151_b.get(0)) != null) {
            KnappingRecipe recipe = this.getMatchingRecipe();
            if (recipe != null) {
                slot.func_75215_d(recipe.getOutput(this.stackCopy));
            } else {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        Slot slot = (Slot)this.field_75151_b.get(0);
        ItemStack stack = slot.func_75211_c();
        if (!stack.func_190926_b() && !player.field_70170_p.field_72995_K) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            this.consumeIngredientStackAfterComplete();
        }
        super.func_75134_a(player);
    }

    public boolean getSlotState(int index) {
        return this.matrix.get(index);
    }

    public void setSlotState(int index, boolean value) {
        this.matrix.set(index, value);
    }

    @Override
    protected void addContainerSlots() {
        this.func_75146_a((Slot)new SlotKnappingOutput((IItemHandler)new ItemStackHandler(1), 0, 128, 44, this::resetMatrix));
    }

    @Override
    protected void addPlayerInventorySlots(InventoryPlayer playerInv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 160));
        }
    }

    private void resetMatrix() {
        this.matrix.setAll(false);
        this.requiresReset = true;
        this.consumeIngredientStackAfterComplete();
    }

    private KnappingRecipe getMatchingRecipe() {
        return TFCRegistries.KNAPPING.getValuesCollection().stream().filter(x -> x.getType() == this.type && this.matrix.matches(x.getMatrix())).findFirst().orElse(null);
    }

    private void consumeIngredientStackAfterComplete() {
        if (this.type.consumeAfterComplete()) {
            ItemStack stack = Helpers.consumeItem(this.stack, this.type.getAmountToConsume());
            if (this.isOffhand) {
                this.player.func_184611_a(EnumHand.OFF_HAND, stack);
            } else {
                this.player.func_184611_a(EnumHand.MAIN_HAND, stack);
            }
        }
    }
}

