/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.container.ContainerTE;
import net.dries007.tfc.objects.container.IButtonHandler;
import net.dries007.tfc.objects.inventory.slot.SlotCallback;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.forge.ForgeStep;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
public class ContainerAnvilTFC
extends ContainerTE<TEAnvilTFC>
implements IButtonHandler {
    public ContainerAnvilTFC(InventoryPlayer playerInv, TEAnvilTFC te) {
        super(playerInv, te, 26);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable NBTTagCompound extraNBT) {
        ItemStack stack;
        Slot slotInput;
        if (buttonID >= 0 && buttonID <= 7) {
            if (this.attemptWork()) {
                ((TEAnvilTFC)this.tile).addStep(this.player, ForgeStep.valueOf(buttonID - 0));
            }
        } else if (buttonID == 8 && (slotInput = (Slot)this.field_75151_b.get(0)) != null && !(stack = slotInput.func_75211_c()).func_190926_b() && !AnvilRecipe.getAllFor(stack).isEmpty()) {
            TFCGuiHandler.openGui(this.player.field_70170_p, ((TEAnvilTFC)this.tile).func_174877_v(), this.player, TFCGuiHandler.Type.ANVIL_PLAN);
        }
    }

    @Override
    protected void addContainerSlots() {
        IItemHandler inventory = (IItemHandler)((TEAnvilTFC)this.tile).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inventory != null) {
            this.func_75146_a((Slot)new SlotCallback(inventory, 0, 31, 68, this.tile));
            this.func_75146_a((Slot)new SlotCallback(inventory, 1, 13, 68, this.tile));
            this.func_75146_a((Slot)new SlotCallback(inventory, 2, 129, 68, this.tile));
            this.func_75146_a((Slot)new SlotCallback(inventory, 3, 147, 68, this.tile));
        }
    }

    @Override
    protected boolean transferStackIntoContainer(ItemStack stack, int containerSlots) {
        return !this.func_75135_a(stack, 3, 4, false) && !this.func_75135_a(stack, 2, 3, false) && !this.func_75135_a(stack, 0, 2, false);
    }

    private boolean attemptWork() {
        Slot slotInput = (Slot)this.field_75151_b.get(0);
        if (slotInput == null) {
            return false;
        }
        ItemStack stack = slotInput.func_75211_c();
        IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap == null) {
            return false;
        }
        AnvilRecipe recipe = (AnvilRecipe)TFCRegistries.ANVIL.getValue(cap.getRecipeName());
        if (recipe == null) {
            return false;
        }
        if (!((TEAnvilTFC)this.tile).getTier().isAtLeast(recipe.getTier())) {
            TerraFirmaCraft.getLog().info("Anvil Tier: {} + Recipe Tier: {}", (Object)((TEAnvilTFC)this.tile).getTier(), (Object)recipe.getTier());
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_tier_too_low", new Object[0]));
            return false;
        }
        if (!cap.isWorkable()) {
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_too_cold", new Object[0]));
            return false;
        }
        Slot slot = (Slot)this.field_75151_b.get(2);
        if (slot == null) {
            return false;
        }
        stack = slot.func_75211_c();
        if (!stack.func_190926_b()) {
            stack.func_77972_a(1, (EntityLivingBase)this.player);
            if (stack.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(stack);
            }
            return true;
        }
        stack = (ItemStack)this.player.field_71071_by.field_70462_a.get(this.player.field_71071_by.field_70461_c);
        if (!stack.func_190926_b() && OreDictionaryHelper.doesStackMatchOre(stack, "hammer")) {
            stack.func_77972_a(1, (EntityLivingBase)this.player);
            return true;
        }
        this.player.func_145747_a(new TextComponentString("" + TextFormatting.RED).func_150257_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_no_hammer", new Object[0])));
        return false;
    }
}

