/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.container;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.egg.CapabilityEgg;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.network.PacketCapabilityContainerUpdate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
public class CapabilityContainerListener
implements IContainerListener {
    public static final Map<String, Capability<? extends INBTSerializable<? extends NBTBase>>> SYNC_CAPS = new HashMap<String, Capability<? extends INBTSerializable<? extends NBTBase>>>();
    private static final Map<EntityPlayerMP, IContainerListener> CAPABILITY_LISTENERS = new HashMap<EntityPlayerMP, IContainerListener>();
    private final EntityPlayerMP player;

    public static void addTo(Container container, EntityPlayerMP player) {
        IContainerListener listener = CAPABILITY_LISTENERS.computeIfAbsent(player, CapabilityContainerListener::new);
        try {
            container.func_75132_a(listener);
        }
        catch (IllegalArgumentException e) {
            listener.func_71110_a(container, container.func_75138_a());
            container.func_75142_b();
        }
    }

    public static void removeFrom(EntityPlayerMP player) {
        CAPABILITY_LISTENERS.remove(player);
    }

    public static void syncCapabilityOnlyChanges(Container container, EntityPlayerMP player) {
        IContainerListener listener = CAPABILITY_LISTENERS.computeIfAbsent(player, CapabilityContainerListener::new);
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            ItemStack newStack = ((Slot)container.field_75151_b.get(i)).func_75211_c();
            ItemStack cachedStack = (ItemStack)container.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)cachedStack, (ItemStack)newStack)) continue;
            boolean clientStackChanged = !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)cachedStack, (ItemStack)newStack);
            ItemStack itemStack = cachedStack = newStack.func_190926_b() ? ItemStack.field_190927_a : newStack.func_77946_l();
            if (clientStackChanged) continue;
            listener.func_71111_a(container, i, cachedStack);
        }
    }

    @Nonnull
    public static NBTTagCompound readShareTag(ItemStack stack) {
        NBTTagCompound capNbt;
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound stackNbt = stack.func_77978_p();
        if (stackNbt != null) {
            if (stackNbt.func_82582_d()) {
                nbt.func_74757_a("empty", true);
            }
            nbt.func_74782_a("stack", (NBTBase)stackNbt);
        }
        if (!(capNbt = CapabilityContainerListener.readCapabilityData(stack)).func_82582_d()) {
            nbt.func_74782_a("caps", (NBTBase)capNbt);
        }
        return nbt;
    }

    public static void applyShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            NBTTagCompound capNbt;
            NBTTagCompound stackNbt = nbt.func_74775_l("stack");
            if (!stackNbt.func_82582_d() || nbt.func_74767_n("empty")) {
                stack.func_77982_d(stackNbt);
            }
            if (!(capNbt = nbt.func_74775_l("caps")).func_82582_d()) {
                CapabilityContainerListener.applyCapabilityData(stack, capNbt);
            }
        }
    }

    @Nonnull
    public static NBTTagCompound readCapabilityData(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        SYNC_CAPS.forEach((name, cap) -> {
            INBTSerializable capability = (INBTSerializable)stack.getCapability(cap, null);
            if (capability != null) {
                nbt.func_74782_a(name, capability.serializeNBT());
            }
        });
        return nbt;
    }

    public static void applyCapabilityData(ItemStack stack, NBTTagCompound nbt) {
        SYNC_CAPS.forEach((name, cap) -> {
            INBTSerializable capability = (INBTSerializable)stack.getCapability(cap, null);
            if (capability != null) {
                capability.deserializeNBT(nbt.func_74781_a(name));
            }
        });
    }

    public static boolean shouldSyncItem(ItemStack stack) {
        for (Capability<? extends INBTSerializable<? extends NBTBase>> capability : SYNC_CAPS.values()) {
            if (!stack.hasCapability(capability, null)) continue;
            return true;
        }
        return false;
    }

    public CapabilityContainerListener(EntityPlayerMP player) {
        this.player = player;
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> items) {
        NonNullList filteredItems = NonNullList.func_191197_a((int)items.size(), (Object)ItemStack.field_190927_a);
        for (int index = 0; index < items.size(); ++index) {
            ItemStack stack = (ItemStack)items.get(index);
            if (CapabilityContainerListener.shouldSyncItem(stack)) {
                filteredItems.set(index, (Object)stack);
                continue;
            }
            filteredItems.set(index, (Object)ItemStack.field_190927_a);
        }
        PacketCapabilityContainerUpdate message = new PacketCapabilityContainerUpdate(container.field_75152_c, (NonNullList<ItemStack>)filteredItems);
        if (message.hasData()) {
            TerraFirmaCraft.getNetwork().sendTo((IMessage)message, this.player);
        }
    }

    public void func_71111_a(Container container, int slotIndex, ItemStack stack) {
        PacketCapabilityContainerUpdate message;
        if (CapabilityContainerListener.shouldSyncItem(stack) && (message = new PacketCapabilityContainerUpdate(container.field_75152_c, slotIndex, stack)).hasData()) {
            TerraFirmaCraft.getNetwork().sendTo((IMessage)message, this.player);
        }
    }

    public void func_71112_a(Container container, int ID, int value) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }

    static {
        SYNC_CAPS.put(CapabilityItemHeat.KEY.toString(), CapabilityItemHeat.ITEM_HEAT_CAPABILITY);
        SYNC_CAPS.put(CapabilityForgeable.KEY.toString(), CapabilityForgeable.FORGEABLE_CAPABILITY);
        SYNC_CAPS.put(CapabilityFood.KEY.toString(), CapabilityFood.CAPABILITY);
        SYNC_CAPS.put(CapabilityEgg.KEY.toString(), CapabilityEgg.CAPABILITY);
    }
}

