/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.objects.te.TELogPile;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockLogPile
extends Block
implements ILightableBlock {
    private static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});

    public static boolean isValidCoverBlock(IBlockState state) {
        if (state.func_177230_c() == BlocksTFC.LOG_PILE || state.func_177230_c() == BlocksTFC.CHARCOAL_PILE) {
            return true;
        }
        if (ConfigTFC.Devices.CHARCOAL_PIT.canAcceptGlass) {
            return state.func_185904_a() == Material.field_151592_s && !(state.func_177230_c() instanceof BlockPane);
        }
        return !state.func_185904_a().func_76217_h() && state.func_185915_l();
    }

    private static boolean isValidCoverBlock(IBlockState offsetState, World world, BlockPos pos, EnumFacing side) {
        if (offsetState.func_177230_c() instanceof BlockLogPile || offsetState.func_177230_c() == BlocksTFC.CHARCOAL_PILE) {
            return true;
        }
        if (offsetState.func_185904_a() == Material.field_151592_s && ConfigTFC.Devices.CHARCOAL_PIT.canAcceptGlass) {
            return offsetState.func_193401_d((IBlockAccess)world, pos, side) == BlockFaceShape.SOLID || offsetState.isSideSolid((IBlockAccess)world, pos, side);
        }
        return !offsetState.func_185904_a().func_76217_h() && offsetState.func_193401_d((IBlockAccess)world, pos, side) == BlockFaceShape.SOLID || offsetState.isSideSolid((IBlockAccess)world, pos, side);
    }

    public BlockLogPile() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)(meta == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta >= 2));
    }

    public int func_176201_c(IBlockState state) {
        return (state.func_177229_b(AXIS) == EnumFacing.Axis.Z ? 0 : 1) + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 2 : 0);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            for (EnumFacing side : EnumFacing.values()) {
                BlockPos offsetPos = pos.func_177972_a(side);
                IBlockState offsetState = worldIn.func_180495_p(offsetPos);
                if (BlockLogPile.isValidCoverBlock(offsetState, worldIn, offsetPos, side.func_176734_d())) {
                    if (!(offsetState.func_177230_c() instanceof BlockLogPile) || ((Boolean)offsetState.func_177229_b((IProperty)LIT)).booleanValue()) continue;
                    worldIn.func_175656_a(offsetPos, offsetState.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                    continue;
                }
                worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, (double)(0.1f + 0.1f * rand.nextFloat()), 0.0, new int[0]);
            if (worldIn.func_82737_E() % 80L == 0L) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.5f, 0.6f, false);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150480_ab) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            TELogPile te = Helpers.getTE((IBlockAccess)worldIn, pos, TELogPile.class);
            if (te != null) {
                te.light();
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TELogPile te = Helpers.getTE((IBlockAccess)world, pos, TELogPile.class);
        if (te != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && side == EnumFacing.UP && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos) && ItemFireStarter.onIgnition(stack)) {
                if (!world.field_72995_K) {
                    TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                    world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                    te.light();
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                return true;
            }
            if (OreDictionaryHelper.doesStackMatchOre(stack, "logWood")) {
                if (!player.func_70093_af()) {
                    if (te.insertLog(stack.func_77946_l())) {
                        if (!world.field_72995_K) {
                            world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            stack.func_190918_g(1);
                            player.func_184611_a(hand, stack);
                        }
                        return true;
                    }
                } else {
                    int inserted = te.insertLogs(stack.func_77946_l());
                    if (inserted > 0) {
                        if (!world.field_72995_K) {
                            world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            stack.func_190918_g(inserted);
                            player.func_184611_a(hand, stack);
                        }
                        return true;
                    }
                }
            }
            if (!player.func_70093_af() && !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                if (!world.field_72995_K) {
                    TFCGuiHandler.openGui(world, pos, player, TFCGuiHandler.Type.LOG_PILE);
                }
                return true;
            }
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.func_174811_aO().func_176740_k().func_176722_c()) {
            return this.func_176223_P().func_177226_a(AXIS, (Comparable)placer.func_174811_aO().func_176740_k());
        }
        return this.func_176223_P();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && te instanceof TEInventory) {
            ((TEInventory)te).onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, LIT});
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TELogPile();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TELogPile te = Helpers.getTE((IBlockAccess)world, pos, TELogPile.class);
        if (te != null) {
            return te.getLog().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }
}

