/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlockPeat;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockShortGrassTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariantFallable;
import net.dries007.tfc.objects.entity.EntityFallingBlockTFC;
import net.dries007.tfc.util.IFallingBlock;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRockVariantConnected
extends BlockRockVariantFallable {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public static void spreadGrass(World world, BlockPos pos, IBlockState us, Random rand) {
        block8: {
            IBlockState stateUp;
            block6: {
                block7: {
                    stateUp = world.func_180495_p(pos.func_177984_a());
                    if ((world.func_175671_l(pos.func_177984_a()) >= 4 || stateUp.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) <= 2) && !stateUp.func_185904_a().func_76224_d()) break block6;
                    if (!(us.func_177230_c() instanceof BlockPeat)) break block7;
                    world.func_175656_a(pos, BlocksTFC.PEAT.func_176223_P());
                    break block8;
                }
                if (!(us.func_177230_c() instanceof BlockRockVariant)) break block8;
                BlockRockVariant block = (BlockRockVariant)us.func_177230_c();
                world.func_175656_a(pos, block.getVariant(block.getType().getNonGrassVersion()).func_176223_P());
                break block8;
            }
            if (world.func_175671_l(pos.func_177984_a()) < 9 || stateUp.func_185904_a().func_76224_d()) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                BlockPos target = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (world.func_189509_E(target) || !world.func_175667_e(target)) {
                    return;
                }
                BlockPos up = target.func_177982_a(0, 1, 0);
                IBlockState current = world.func_180495_p(target);
                if (!BlocksTFC.isSoil(current) || BlocksTFC.isGrass(current) || world.func_175671_l(up) < 4 || world.func_180495_p(up).getLightOpacity((IBlockAccess)world, up) > 3 || world.func_180495_p(up).func_185904_a().func_76224_d()) continue;
                if (current.func_177230_c() instanceof BlockPeat) {
                    world.func_175656_a(target, BlocksTFC.PEAT_GRASS.func_176223_P());
                    continue;
                }
                if (!(current.func_177230_c() instanceof BlockRockVariant)) continue;
                Rock.Type spreader = Rock.Type.GRASS;
                if (us.func_177230_c() instanceof BlockRockVariant && ((BlockRockVariant)us.func_177230_c()).getType() == Rock.Type.DRY_GRASS) {
                    spreader = Rock.Type.DRY_GRASS;
                }
                BlockRockVariant block = (BlockRockVariant)current.func_177230_c();
                world.func_175656_a(target, block.getVariant(block.getType().getGrassVersion(spreader)).func_176223_P());
            }
            for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                if (plant.getPlantType() != Plant.PlantType.SHORT_GRASS || !(rand.nextFloat() < 0.5f)) continue;
                float temp = ClimateTFC.getActualTemp(world, pos.func_177984_a());
                BlockShortGrassTFC plantBlock = BlockShortGrassTFC.get(plant);
                if (!world.func_175623_d(pos.func_177984_a()) || !plant.isValidLocation(temp, ChunkDataTFC.getRainfall(world, pos.func_177984_a()), Math.subtractExact(world.func_175642_b(EnumSkyBlock.SKY, pos.func_177984_a()), world.func_175657_ab())) || !plant.isValidGrowthTemp(temp) || !(rand.nextDouble() < plantBlock.getGrowthRate(world, pos.func_177984_a()))) continue;
                world.func_175656_a(pos.func_177984_a(), plantBlock.func_176223_P());
            }
        }
    }

    public BlockRockVariantConnected(Rock.Type type, Rock rock) {
        super(type, rock);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        pos = pos.func_177982_a(0, -1, 0);
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)))));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    @Override
    public boolean checkFalling(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos pos1 = this.getFallablePos(worldIn, pos);
        if (pos1 != null) {
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!pos1.equals((Object)pos)) {
                    worldIn.func_175698_g(pos);
                }
                if (this.type.getNonGrassVersion() != this.type) {
                    worldIn.func_175656_a(pos1, BlockRockVariant.get(this.rock, this.type.getNonGrassVersion()).func_176223_P());
                }
                worldIn.func_72838_d((Entity)new EntityFallingBlockTFC(worldIn, pos1, this, worldIn.func_180495_p(pos1)));
            } else {
                worldIn.func_175698_g(pos);
                pos1 = pos1.func_177977_b();
                while (IFallingBlock.canFallThrough(worldIn, pos1, state.func_185904_a()) && pos1.func_177956_o() > 0) {
                    pos1 = pos1.func_177977_b();
                }
                if (pos1.func_177956_o() > 0) {
                    worldIn.func_175656_a(pos1.func_177984_a(), state);
                }
            }
            return true;
        }
        return false;
    }
}

