/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.items.metal.ItemOreTFC;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockOreTFC
extends Block {
    public static final PropertyEnum<Ore.Grade> GRADE = PropertyEnum.func_177709_a((String)"grade", Ore.Grade.class);
    private static final Map<Ore, Map<Rock, BlockOreTFC>> TABLE = new HashMap<Ore, Map<Rock, BlockOreTFC>>();
    public final Ore ore;
    public final Rock rock;

    public static BlockOreTFC get(Ore ore, Rock rock) {
        return TABLE.get((Object)ore).get((Object)rock);
    }

    public static IBlockState get(Ore ore, Rock rock, Ore.Grade grade) {
        IBlockState state = TABLE.get((Object)ore).get((Object)rock).func_176223_P();
        if (!ore.isGraded()) {
            return state;
        }
        return state.func_177226_a(GRADE, (Comparable)((Object)grade));
    }

    public BlockOreTFC(Ore ore, Rock rock) {
        super(Rock.Type.RAW.material);
        if (!TABLE.containsKey((Object)ore)) {
            TABLE.put(ore, new HashMap());
        }
        TABLE.get((Object)ore).put(rock, this);
        this.ore = ore;
        this.rock = rock;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(GRADE, (Comparable)((Object)Ore.Grade.NORMAL)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(10.0f).func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(GRADE, (Comparable)((Object)Ore.Grade.valueOf(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Ore.Grade)((Object)state.func_177229_b(GRADE))).getMeta();
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemOreTFC.get(this.ore);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GRADE});
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c());
    }
}

