/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockWaterPlantTFC
extends BlockPlantTFC {
    private static final Map<Plant, BlockWaterPlantTFC> MAP = new HashMap<Plant, BlockWaterPlantTFC>();

    public static BlockWaterPlantTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockWaterPlantTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (this.plant.getWaterType() == ChunkGenTFC.SALT_WATER) {
            return BlocksTFC.isSaltWater(worldIn.func_180495_p(pos)) && this.func_185514_i(soil);
        }
        return BlocksTFC.isFreshWater(worldIn.func_180495_p(pos)) && this.func_185514_i(soil);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, this.plant.getWaterType(), world.field_72995_K ? 11 : 3);
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175656_a(pos, this.plant.getWaterType());
        }
    }
}

