/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockShortGrassTFC;
import net.dries007.tfc.objects.blocks.property.ITallPlant;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class BlockTallGrassTFC
extends BlockShortGrassTFC
implements IGrowable,
ITallPlant {
    private static final PropertyEnum<ITallPlant.EnumBlockPart> PART = PropertyEnum.func_177709_a((String)"part", ITallPlant.EnumBlockPart.class);
    private static final Map<Plant, BlockTallGrassTFC> MAP = new HashMap<Plant, BlockTallGrassTFC>();

    public static BlockTallGrassTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockTallGrassTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a(PART, (Comparable)((Object)this.getPlantPart(worldIn, pos)));
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, worldIn.func_180495_p(pos));
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (worldIn.func_180495_p(pos.func_177979_c(this.plant.getMaxHeight())).func_177230_c() == this) {
            return false;
        }
        if (state.func_177230_c() == this) {
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) && this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return this.func_185514_i(soil);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.getPlantPart((IBlockAccess)worldIn, pos) == ITallPlant.EnumBlockPart.LOWER) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)AGE)));
        }
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            if (this.getPlantPart((IBlockAccess)worldIn, pos) != ITallPlant.EnumBlockPart.UPPER) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        int i = 1;
        while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
            ++i;
        }
        return i < this.plant.getMaxHeight() && worldIn.func_175623_d(pos.func_177984_a()) && this.func_180671_f(worldIn, pos.func_177984_a(), state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
        IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos)));
        worldIn.func_175656_a(pos, iblockstate);
        iblockstate.func_189546_a(worldIn, pos.func_177984_a(), (Block)this, pos);
    }

    public void shrink(World worldIn, BlockPos pos) {
        worldIn.func_175698_g(pos);
        worldIn.func_180495_p(pos).func_189546_a(worldIn, pos.func_177977_b(), (Block)this, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack stack;
        if (!(worldIn.field_72995_K || player == null || (stack = player.func_184614_ca()).func_77973_b().getHarvestLevel(stack, "knife", player, state) == -1 && stack.func_77973_b().getHarvestLevel(stack, "scythe", player, state) == -1)) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this) {
                if (Constants.RNG.nextDouble() <= (double)((Integer)worldIn.func_180495_p(pos.func_177981_b(i)).func_177229_b((IProperty)AGE) + 1) / 4.0) {
                    BlockTallGrassTFC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)ItemsTFC.STRAW, 1));
                }
                ++i;
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == this) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)true)) {
                if (j == 3 && this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K)) {
                    this.func_176474_b(worldIn, rand, pos, state);
                } else if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        } else if (!this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, pos))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (j == 0 && this.canShrink(worldIn, pos)) {
                    this.shrink(worldIn, pos);
                } else if (j > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j - 1)).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getTallBoundingBax((Integer)state.func_177229_b((IProperty)AGE), state, source, pos);
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, this.growthStageProperty, DAYPERIOD, PART});
    }

    @Override
    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1));
    }

    private boolean canShrink(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this;
    }
}

