/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;

@ParametersAreNonnullByDefault
public class BlockShortGrassTFC
extends BlockPlantTFC
implements IShearable {
    private static final AxisAlignedBB GRASS_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB SHORTER_GRASS_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);
    private static final AxisAlignedBB SHORT_GRASS_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
    private static final AxisAlignedBB SHORTEST_GRASS_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private static final Map<Plant, BlockShortGrassTFC> MAP = new HashMap<Plant, BlockShortGrassTFC>();

    public static BlockShortGrassTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockShortGrassTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            BlockShortGrassTFC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1));
        } else if ((!worldIn.field_72995_K && stack.func_77973_b().getHarvestLevel(stack, "knife", player, state) != -1 || stack.func_77973_b().getHarvestLevel(stack, "scythe", player, state) != -1) && Constants.RNG.nextDouble() <= (double)((Integer)state.func_177229_b((IProperty)AGE) + 1) / 4.0) {
            BlockShortGrassTFC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)ItemsTFC.STRAW, 1));
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)true)) {
                if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        } else if (!this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, pos))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (j > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j - 1)));
                } else {
                    worldIn.func_175698_g(pos);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)AGE)) {
            case 0: {
                return SHORTEST_GRASS_AABB.func_191194_a(state.func_191059_e(source, pos));
            }
            case 1: {
                return SHORTER_GRASS_AABB.func_191194_a(state.func_191059_e(source, pos));
            }
            case 2: {
                return SHORT_GRASS_AABB.func_191194_a(state.func_191059_e(source, pos));
            }
        }
        return GRASS_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, this.growthStageProperty, DAYPERIOD});
    }

    public int func_149679_a(int fortune, Random random) {
        return 1 + random.nextInt(fortune * 2 + 1);
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1);
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1));
    }
}

