/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class BlockPlantTFC
extends BlockBush
implements IItemSize {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public static final PropertyInteger DAYPERIOD = PropertyInteger.func_177719_a((String)"dayperiod", (int)0, (int)3);
    private static final AxisAlignedBB PLANT_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final Map<Plant, BlockPlantTFC> MAP = new HashMap<Plant, BlockPlantTFC>();
    public final PropertyInteger growthStageProperty;
    protected final Plant plant;
    protected final BlockStateContainer field_176227_L;

    public static BlockPlantTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockPlantTFC(Plant plant) {
        super(plant.getMaterial());
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        plant.getOreDictName().ifPresent(name -> OreDictionaryHelper.register((Block)this, name));
        this.plant = plant;
        this.growthStageProperty = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)plant.getNumStages());
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
        this.field_176227_L = this.createPlantBlockState();
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(this.getDayPeriod())).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth()));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        int expectedTime;
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        Month currentMonth = CalendarTFC.CALENDAR_TIME.getMonthOfYear();
        int currentStage = (Integer)state.func_177229_b((IProperty)this.growthStageProperty);
        int expectedStage = this.plant.getStageForMonth(currentMonth);
        int currentTime = (Integer)state.func_177229_b((IProperty)DAYPERIOD);
        if (currentTime != (expectedTime = this.getDayPeriod())) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(expectedTime)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(currentStage)));
        }
        if (currentStage != expectedStage && random.nextDouble() < 0.5) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(expectedTime)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(expectedStage)));
        }
        this.func_180650_b(worldIn, pos, state, random);
    }

    public int func_149738_a(World worldIn) {
        return 10;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(this.getDayPeriod())).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())));
        this.func_176475_e(world, pos, state);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (!this.plant.getOreDictName().isPresent()) {
            return Items.field_190931_a;
        }
        return Item.func_150898_a((Block)this);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer) || !((EntityPlayer)entityIn).func_184812_l_()) {
            double modifier = 0.25 * (double)(4 - (Integer)state.func_177229_b((IProperty)AGE));
            if ((modifier = (1.0 - modifier) * this.plant.getMovementMod() + modifier) < ConfigTFC.General.MISC.minimumPlantMovementModifier) {
                modifier = ConfigTFC.General.MISC.minimumPlantMovementModifier;
            }
            entityIn.field_70159_w *= modifier;
            entityIn.field_70179_y *= modifier;
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!(this.plant.getOreDictName().isPresent() || worldIn.field_72995_K || stack.func_77973_b().getHarvestLevel(stack, "knife", player, state) == -1 && stack.func_77973_b().getHarvestLevel(stack, "scythe", player, state) == -1 || this.plant.getPlantType() == Plant.PlantType.SHORT_GRASS || this.plant.getPlantType() == Plant.PlantType.TALL_GRASS)) {
            BlockPlantTFC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1));
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.func_180671_f(worldIn, pos, state) && placer instanceof EntityPlayer && !((EntityPlayer)placer).func_184812_l_() && !this.plant.getOreDictName().isPresent()) {
            BlockPlantTFC.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
        }
    }

    @Nonnull
    public BlockStateContainer func_176194_O() {
        return this.field_176227_L;
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        IBlockState state = world.func_180495_p(pos);
        switch (this.plant.getPlantType()) {
            case REED: 
            case REED_SEA: 
            case TALL_REED: 
            case TALL_REED_SEA: 
            case SHORT_GRASS: 
            case TALL_GRASS: {
                return stack.func_77973_b().getHarvestLevel(stack, "knife", player, state) != -1 || stack.func_77973_b().getHarvestLevel(stack, "scythe", player, state) != -1;
            }
        }
        return true;
    }

    public Plant getPlant() {
        return this.plant;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.TINY;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_LIGHT;
    }

    public double getGrowthRate(World world, BlockPos pos) {
        if (world.func_175727_C(pos)) {
            return ConfigTFC.General.MISC.plantGrowthRate * 5.0;
        }
        return ConfigTFC.General.MISC.plantGrowthRate;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos).func_177230_c() != this && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean func_185514_i(IBlockState state) {
        if (this.plant.getIsClayMarking()) {
            return BlocksTFC.isClay(state) || this.isValidSoil(state);
        }
        return this.isValidSoil(state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)true)) {
                if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        } else if (!this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, pos))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (j > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j - 1)));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == this) {
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) && this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return this.func_185514_i(soil);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PLANT_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (this.plant.getMovementMod() == 0.0) {
            return blockState.func_185900_c(worldIn, pos);
        }
        return field_185506_k;
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        switch (this.plant.getPlantType()) {
            case CACTUS: 
            case DESERT: 
            case DESERT_TALL_PLANT: {
                return EnumPlantType.Desert;
            }
            case FLOATING: 
            case FLOATING_SEA: {
                return EnumPlantType.Water;
            }
            case MUSHROOM: {
                return EnumPlantType.Cave;
            }
        }
        return EnumPlantType.Plains;
    }

    @Nonnull
    public Plant.EnumPlantTypeTFC getPlantTypeTFC() {
        return this.plant.getEnumPlantTypeTFC();
    }

    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.growthStageProperty, DAYPERIOD, AGE});
    }

    int getDayPeriod() {
        return CalendarTFC.CALENDAR_TIME.getHourOfDay() / 6;
    }

    private boolean isValidSoil(IBlockState state) {
        switch (this.plant.getPlantType()) {
            case CACTUS: 
            case DESERT: 
            case DESERT_TALL_PLANT: {
                return BlocksTFC.isSand(state);
            }
            case DRY: 
            case DRY_TALL_PLANT: {
                return BlocksTFC.isSand(state) || BlocksTFC.isDryGrass(state);
            }
            case REED: 
            case REED_SEA: 
            case TALL_REED: 
            case TALL_REED_SEA: {
                return BlocksTFC.isSand(state) || BlocksTFC.isSoil(state);
            }
            case WATER: 
            case TALL_WATER: 
            case EMERGENT_TALL_WATER: {
                return BlocksTFC.isSoilOrGravel(state);
            }
            case WATER_SEA: 
            case TALL_WATER_SEA: 
            case EMERGENT_TALL_WATER_SEA: {
                return BlocksTFC.isSand(state) || BlocksTFC.isSoilOrGravel(state);
            }
        }
        return BlocksTFC.isSoil(state);
    }
}

