/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockCreepingPlantTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

@ParametersAreNonnullByDefault
public class BlockHangingPlantTFC
extends BlockCreepingPlantTFC
implements IGrowable {
    private static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    private static final Map<Plant, BlockHangingPlantTFC> MAP = new HashMap<Plant, BlockHangingPlantTFC>();

    public static BlockHangingPlantTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockHangingPlantTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177979_c(2));
        Material material = iblockstate.func_185904_a();
        int i = 1;
        while (worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this) {
            ++i;
        }
        return i < this.plant.getMaxHeight() && worldIn.func_175623_d(pos.func_177977_b()) && (!material.func_76220_a() || material == Material.field_151584_j) && this.func_180671_f(worldIn, pos.func_177977_b(), state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos.func_177977_b(), this.func_176223_P());
        IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(false));
        worldIn.func_175656_a(pos, iblockstate);
        iblockstate.func_189546_a(worldIn, pos.func_177977_b(), (Block)this, pos);
    }

    public void shrink(World worldIn, BlockPos pos) {
        worldIn.func_175698_g(pos);
        worldIn.func_180495_p(pos).func_189546_a(worldIn, pos.func_177984_a(), (Block)this, pos);
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState = super.func_176221_a(state, worldIn, pos);
        if (!(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this || !((Boolean)actualState.func_177229_b((IProperty)UP)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)DOWN)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue())) {
            actualState = actualState.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(true));
        }
        if (!(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this || ((Boolean)actualState.func_177229_b((IProperty)UP)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue())) {
            actualState = (Boolean)actualState.func_177229_b((IProperty)DOWN) == false ? actualState.func_185899_b(worldIn, pos.func_177984_a()).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)) : actualState.func_185899_b(worldIn, pos.func_177984_a()).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false));
        }
        return actualState.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(this.getIsBottom(worldIn, pos)));
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        for (EnumFacing face : EnumFacing.values()) {
            IBlockState blockState = worldIn.func_180495_p(pos.func_177972_a(face));
            Material material = blockState.func_185904_a();
            if (material != Material.field_151584_j && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) continue;
            return this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return false;
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, EAST, WEST, SOUTH, this.growthStageProperty, DAYPERIOD, AGE, BOTTOM});
    }

    @Override
    protected boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Material material = iblockstate.func_185904_a();
        return material == Material.field_151584_j;
    }

    @Override
    protected boolean canPlantConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (!super.canPlantConnectTo(world, pos, facing) && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && facing != EnumFacing.DOWN && facing != EnumFacing.UP) {
            return this.canPlantConnectTo(world, pos.func_177984_a(), facing);
        }
        return super.canPlantConnectTo(world, pos, facing);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177977_b(), (IBlockState)state, (boolean)true)) {
                if (j == 3) {
                    if (this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K)) {
                        this.func_176474_b(worldIn, rand, pos, state);
                    } else if (this.canGrowHorizontally(worldIn, pos, state)) {
                        this.growHorizontally(worldIn, rand, pos, state);
                    } else if (this.canGrowDiagonally(worldIn, pos, state)) {
                        this.growDiagonally(worldIn, rand, pos, state);
                    }
                } else if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(this.getIsBottom((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        } else if (!this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, pos))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (j == 0) {
                    if (this.canShrink(worldIn, pos)) {
                        this.shrink(worldIn, pos);
                    } else if (this.canShrinkHorizontally(worldIn, pos)) {
                        this.shrinkHorizontally(worldIn, pos);
                    }
                } else if (j > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j - 1)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(this.getIsBottom((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    private boolean canGrowDiagonally(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag = false;
        if (!((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                BlockPos sidePos = pos.func_177972_a(face);
                IBlockState sideState = worldIn.func_180495_p(sidePos.func_177979_c(2));
                Material sideMaterial = sideState.func_185904_a();
                if (!worldIn.func_175623_d(sidePos) || !worldIn.func_175623_d(sidePos.func_177977_b()) || sideMaterial.func_76220_a() && sideMaterial != Material.field_151584_j || !this.func_180671_f(worldIn, sidePos.func_177977_b(), state)) continue;
                flag = true;
            }
        }
        return flag;
    }

    private void growDiagonally(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                BlockPos sidePos = pos.func_177972_a(face);
                if (!(rand.nextDouble() < 0.5) || !worldIn.func_175623_d(sidePos) || !worldIn.func_175623_d(sidePos.func_177977_b())) continue;
                worldIn.func_175656_a(sidePos.func_177977_b(), this.func_176223_P());
                IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth()));
                worldIn.func_175656_a(pos, iblockstate);
                iblockstate.func_189546_a(worldIn, sidePos.func_177977_b(), (Block)this, pos);
                break;
            }
        }
    }

    private boolean canGrowHorizontally(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag = false;
        for (EnumFacing face : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
            BlockPos sidePos = pos.func_177972_a(face);
            IBlockState sideState = worldIn.func_180495_p(sidePos.func_177977_b());
            Material sideMaterial = sideState.func_185904_a();
            if (!worldIn.func_175623_d(sidePos) || sideMaterial.func_76220_a() && sideMaterial != Material.field_151584_j || !this.func_180671_f(worldIn, sidePos, state)) continue;
            flag = true;
        }
        return flag;
    }

    private void growHorizontally(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        for (EnumFacing face : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
            BlockPos sidePos = pos.func_177972_a(face);
            if (!(rand.nextDouble() < 0.01) || !worldIn.func_175623_d(sidePos)) continue;
            worldIn.func_175656_a(sidePos, this.func_176223_P());
            IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth()));
            worldIn.func_175656_a(pos, iblockstate);
            iblockstate.func_189546_a(worldIn, sidePos, (Block)this, pos);
            break;
        }
    }

    private void shrinkHorizontally(World worldIn, BlockPos pos) {
        worldIn.func_175698_g(pos);
        IBlockState state = worldIn.func_180495_p(pos);
        state.func_189546_a(worldIn, pos.func_177974_f(), (Block)this, pos);
        state.func_189546_a(worldIn, pos.func_177976_e(), (Block)this, pos);
        state.func_189546_a(worldIn, pos.func_177978_c(), (Block)this, pos);
        state.func_189546_a(worldIn, pos.func_177968_d(), (Block)this, pos);
    }

    private boolean canShrink(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this;
    }

    private boolean canShrinkHorizontally(World worldIn, BlockPos pos) {
        boolean flag = false;
        for (EnumFacing face : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
            if (worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c() != this) continue;
            flag = true;
        }
        return flag;
    }

    private boolean getIsBottom(IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177977_b());
        Material material = iblockstate.func_185904_a();
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() != this && !material.func_76220_a();
    }
}

