/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockCreepingPlantTFC
extends BlockPlantTFC {
    static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool[] ALL_FACES = new PropertyBool[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    private static final Map<Plant, BlockCreepingPlantTFC> MAP = new HashMap<Plant, BlockCreepingPlantTFC>();

    public static BlockCreepingPlantTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockCreepingPlantTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canPlantConnectTo(worldIn, pos, EnumFacing.DOWN))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canPlantConnectTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canPlantConnectTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canPlantConnectTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canPlantConnectTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canPlantConnectTo(worldIn, pos, EnumFacing.WEST)));
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        for (EnumFacing face : EnumFacing.values()) {
            IBlockState blockState = worldIn.func_180495_p(pos.func_177972_a(face));
            if (blockState.func_177230_c() instanceof BlockLeavesTFC || blockState.func_193401_d((IBlockAccess)worldIn, pos.func_177972_a(face), face.func_176734_d()) != BlockFaceShape.SOLID && !(blockState.func_177230_c() instanceof BlockFence)) continue;
            return this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return false;
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int i = 0;
        AxisAlignedBB axisalignedbb = field_185505_j;
        block16: for (PropertyBool propertybool : ALL_FACES) {
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            switch (propertybool.func_177701_a()) {
                case "down": {
                    axisalignedbb = DOWN_AABB;
                    ++i;
                    continue block16;
                }
                case "up": {
                    axisalignedbb = UP_AABB;
                    ++i;
                    continue block16;
                }
                case "north": {
                    axisalignedbb = NORTH_AABB;
                    ++i;
                    continue block16;
                }
                case "south": {
                    axisalignedbb = SOUTH_AABB;
                    ++i;
                    continue block16;
                }
                case "west": {
                    axisalignedbb = WEST_AABB;
                    ++i;
                    continue block16;
                }
                case "east": {
                    axisalignedbb = EAST_AABB;
                    ++i;
                    continue block16;
                }
                default: {
                    axisalignedbb = field_185505_j;
                }
            }
        }
        return i == 1 ? axisalignedbb : field_185505_j;
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, EAST, WEST, SOUTH, this.growthStageProperty, DAYPERIOD, AGE});
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state.func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth()));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectTo(world, pos.func_177972_a(facing), facing.func_176734_d()) && !(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockFence);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(worldIn, pos, facing);
        Block block = iblockstate.func_177230_c();
        return blockfaceshape == BlockFaceShape.SOLID || block instanceof BlockFence;
    }

    protected boolean canPlantConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, facing.func_176734_d());
    }
}

