/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.property.ITallPlant;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class BlockCactusTFC
extends BlockPlantTFC
implements IGrowable,
ITallPlant {
    private static final PropertyEnum<ITallPlant.EnumBlockPart> PART = PropertyEnum.func_177709_a((String)"part", ITallPlant.EnumBlockPart.class);
    private static final Map<Plant, BlockCactusTFC> MAP = new HashMap<Plant, BlockCactusTFC>();

    public static BlockCactusTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockCactusTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.25f);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        int i = 1;
        while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
            ++i;
        }
        return i < this.plant.getMaxHeight() && worldIn.func_175623_d(pos.func_177984_a()) && this.func_180671_f(worldIn, pos.func_177984_a(), state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
        IBlockState iblockstate = state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(this.getDayPeriod())).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos)));
        worldIn.func_175656_a(pos, iblockstate);
        iblockstate.func_189546_a(worldIn, pos.func_177984_a(), (Block)this, pos);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == this) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a(PART, (Comparable)((Object)this.getPlantPart(worldIn, pos)));
    }

    @Override
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @Override
    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, worldIn.func_180495_p(pos));
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)true)) {
                if (j == 3 && this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K)) {
                    this.func_176474_b(worldIn, rand, pos, state);
                } else if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(this.getDayPeriod())).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (worldIn.func_180495_p(pos.func_177979_c(this.plant.getMaxHeight())).func_177230_c() == this) {
            return false;
        }
        if (state.func_177230_c() == this) {
            boolean flag = true;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                IBlockState blockState = worldIn.func_180495_p(pos.func_177972_a(enumfacing));
                Material material = blockState.func_185904_a();
                if (!material.func_76220_a() && material != Material.field_151587_i) continue;
                flag = blockState.func_177230_c() == this;
            }
            return flag && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) && this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return this.func_185514_i(soil);
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j.func_191194_a(state.func_191059_e(source, pos));
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, this.growthStageProperty, PART, DAYPERIOD});
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_175655_b(pos, true);
        }
    }
}

