/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.metal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.items.metal.ItemMetalSheet;
import net.dries007.tfc.objects.te.TEMetalSheet;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockMetalSheet
extends Block {
    public static final PropertyBool[] FACE_PROPERTIES = new PropertyBool[]{PropertyBool.func_177716_a((String)"down"), PropertyBool.func_177716_a((String)"up"), PropertyBool.func_177716_a((String)"north"), PropertyBool.func_177716_a((String)"south"), PropertyBool.func_177716_a((String)"west"), PropertyBool.func_177716_a((String)"east")};
    private static final Map<Metal, BlockMetalSheet> MAP = new HashMap<Metal, BlockMetalSheet>();
    private static final AxisAlignedBB[] SHEET_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0)};
    private final Metal metal;

    public static BlockMetalSheet get(Metal metal) {
        return MAP.get((Object)metal);
    }

    public static ItemStack get(Metal metal, int amount) {
        return new ItemStack((Block)MAP.get((Object)metal), amount);
    }

    public BlockMetalSheet(Metal metal) {
        super(Material.field_151573_f);
        this.metal = metal;
        if (MAP.put(metal, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149711_c(40.0f);
        this.func_149752_b(25.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACE_PROPERTIES[0], (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACE_PROPERTIES[1], (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACE_PROPERTIES[2], (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACE_PROPERTIES[3], (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACE_PROPERTIES[4], (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACE_PROPERTIES[5], (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public Metal getMetal() {
        return this.metal;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TEMetalSheet tile = Helpers.getTE(worldIn, pos, TEMetalSheet.class);
        if (tile != null) {
            for (EnumFacing face : EnumFacing.values()) {
                state = state.func_177226_a((IProperty)FACE_PROPERTIES[face.func_176745_a()], (Comparable)Boolean.valueOf(tile.getFace(face)));
            }
        }
        return state;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TEMetalSheet tile = Helpers.getTE(source, pos, TEMetalSheet.class);
        int sheets = 0;
        AxisAlignedBB boundingBox = field_185505_j;
        if (tile != null) {
            for (EnumFacing face : EnumFacing.values()) {
                if (!tile.getFace(face)) continue;
                if (sheets == 1) {
                    return field_185505_j;
                }
                boundingBox = SHEET_AABB[face.func_176745_a()];
                ++sheets;
            }
        }
        return boundingBox;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TEMetalSheet tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEMetalSheet.class);
        if (tile != null) {
            for (EnumFacing face : EnumFacing.values()) {
                if (!tile.getFace(face)) continue;
                BlockMetalSheet.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SHEET_AABB[face.func_176745_a()]);
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)worldIn, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TEMetalSheet tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEMetalSheet.class);
        if (tile != null) {
            for (EnumFacing face : EnumFacing.values()) {
                if (!tile.getFace(face) || worldIn.isSideSolid(pos.func_177972_a(face.func_176734_d()), face)) continue;
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(ItemMetalSheet.get(this.metal, Metal.ItemType.SHEET)));
                tile.setFace(face, false);
            }
            if (tile.getFaceCount() == 0) {
                worldIn.func_175698_g(pos);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEMetalSheet te = Helpers.getTE((IBlockAccess)worldIn, pos, TEMetalSheet.class);
        if (te != null) {
            te.onBreakBlock(this.metal);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        TEMetalSheet tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEMetalSheet.class);
        if (tile != null) {
            for (EnumFacing face : EnumFacing.values()) {
                RayTraceResult result;
                if (!tile.getFace(face) || (result = this.func_185503_a(pos, start, end, SHEET_AABB[face.func_176745_a()])) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])FACE_PROPERTIES);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEMetalSheet();
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemMetalSheet.get(this.metal, Metal.ItemType.SHEET));
    }
}

