/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.metal;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.objects.items.metal.ItemAnvil;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockAnvilTFC
extends Block {
    public static final PropertyDirection AXIS = PropertyDirection.func_177712_a((String)"axis", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final Map<Metal, BlockAnvilTFC> MAP = new HashMap<Metal, BlockAnvilTFC>();
    private static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.6875, 1.0);
    private static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.6875, 0.8125);
    private final Metal metal;

    public static BlockAnvilTFC get(Metal metal) {
        return MAP.get((Object)metal);
    }

    public static ItemStack get(Metal metal, int amount) {
        return new ItemStack((Block)MAP.get((Object)metal), amount);
    }

    public BlockAnvilTFC(Metal metal) {
        super(Material.field_151573_f);
        this.metal = metal;
        if (MAP.put(metal, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149711_c(4.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)AXIS)).func_176736_b();
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumFacing)state.func_177229_b((IProperty)AXIS)).func_176740_k() == EnumFacing.Axis.X ? AABB_Z : AABB_X;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEAnvilTFC te = Helpers.getTE((IBlockAccess)worldIn, pos, TEAnvilTFC.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemAnvil.get(this.metal, Metal.ItemType.ANVIL);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        TEAnvilTFC te = Helpers.getTE((IBlockAccess)worldIn, pos, TEAnvilTFC.class);
        if (te == null) {
            return false;
        }
        IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (cap == null) {
            return false;
        }
        if (playerIn.func_70093_af()) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_190926_b()) {
                for (int i = 0; i < 2; ++i) {
                    ItemStack stack = cap.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    ItemStack result = cap.extractItem(i, 1, false);
                    playerIn.func_184611_a(hand, result);
                    return true;
                }
            } else if (te.isItemValid(2, heldItem)) {
                if (te.attemptWelding(playerIn)) {
                    worldIn.func_184133_a(null, pos, TFCSounds.ANVIL_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    double x = (double)pos.func_177958_n() + 0.5;
                    double y = (double)pos.func_177956_o() + 0.69;
                    double z = (double)pos.func_177952_p() + 0.5;
                    for (int i = 0; i < Constants.RNG.nextInt(5) + 3; ++i) {
                        TFCParticles.SPARK.spawn(worldIn, x + ((double)Constants.RNG.nextFloat() - 0.5) / 7.0, y, z + ((double)Constants.RNG.nextFloat() - 0.5) / 7.0, 6.0 * ((double)Constants.RNG.nextFloat() - 0.5), 2.0, 6.0 * ((double)Constants.RNG.nextFloat() - 0.5), 22);
                    }
                    return true;
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (i == 2 || !te.isItemValid(i, heldItem) || te.getSlotLimit(i) <= cap.getStackInSlot(i).func_190916_E()) continue;
                    ItemStack result = cap.insertItem(i, heldItem, false);
                    playerIn.func_184611_a(hand, result);
                    TerraFirmaCraft.getLog().info("Inserted {} into slot {}", (Object)heldItem.func_82833_r(), (Object)i);
                    return true;
                }
            }
        } else {
            if (!worldIn.field_72995_K) {
                TFCGuiHandler.openGui(worldIn, pos, playerIn, TFCGuiHandler.Type.ANVIL);
            }
            return true;
        }
        return false;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEAnvilTFC();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemAnvil.get(this.metal, Metal.ItemType.ANVIL));
    }

    public Metal getMetal() {
        return this.metal;
    }
}

