/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.te.TESluice;
import net.dries007.tfc.util.block.BoundingBox;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockSluice
extends BlockHorizontal
implements IItemSize {
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    private static final BoundingBox[][] BOXES = new BoundingBox[][]{{new BoundingBox(0.5, 0.0625, 0.125, 0.5, 0.0625, 0.125, EnumFacing.SOUTH), new BoundingBox(0.5, 0.125, 0.375, 0.5, 0.125, 0.125, EnumFacing.SOUTH), new BoundingBox(0.5, 0.1875, 0.625, 0.5, 0.1875, 0.125, EnumFacing.SOUTH), new BoundingBox(0.5, 0.25, 0.875, 0.5, 0.25, 0.125, EnumFacing.SOUTH)}, {new BoundingBox(0.5, 0.3125, 0.125, 0.5, 0.3125, 0.125, EnumFacing.SOUTH), new BoundingBox(0.5, 0.375, 0.375, 0.5, 0.375, 0.125, EnumFacing.SOUTH), new BoundingBox(0.5, 0.4375, 0.625, 0.5, 0.4375, 0.125, EnumFacing.SOUTH), new BoundingBox(0.5, 0.5, 0.875, 0.5, 0.5, 0.125, EnumFacing.SOUTH)}};
    private static final AxisAlignedBB LOWER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockSluice() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(8.0f);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(meta > 3));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)UPPER) != false ? 4 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            return field_185505_j;
        }
        return LOWER_AABB;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_185512_D);
        boolean upper = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)UPPER);
        BoundingBox[] part = BOXES[upper ? 1 : 0];
        for (int i = 0; i < 4; ++i) {
            BlockSluice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)part[i].getAABB(facing));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        Fluid fluid;
        BlockPos fluidPos = pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D), -1).func_177977_b();
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase && TESluice.isValidFluid(fluid = ((BlockFluidBase)block).getFluid())) {
            worldIn.func_175698_g(fluidPos);
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState blockState;
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                BlockSluice.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
            }
            worldIn.func_175698_g(pos);
        }
        if ((blockState = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof BlockFluidBase && (Integer)blockState.func_177229_b((IProperty)BlockFluidBase.LEVEL) < 15) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? Item.func_150898_a((Block)this) : Items.field_190931_a;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        Fluid fluid;
        IBlockState state = worldIn.func_180495_p(pos);
        BlockPos fluidPos = pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D), -1).func_177977_b();
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase && TESluice.isValidFluid(fluid = ((BlockFluidBase)block).getFluid())) {
            worldIn.func_175698_g(fluidPos);
        }
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, UPPER});
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)UPPER);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? new TESluice() : null;
    }
}

