/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.gui.overlay.IHighlightHandler;
import net.dries007.tfc.objects.te.TEQuern;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class BlockQuern
extends Block
implements IItemSize,
IHighlightHandler {
    private static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    private static final AxisAlignedBB QUERN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    private static final AxisAlignedBB HANDSTONE_AABB = new AxisAlignedBB(0.1875, 0.625, 0.1875, 0.8125, 0.86, 0.8125);
    private static final AxisAlignedBB HANDLE_AABB = new AxisAlignedBB(0.27125, 0.86, 0.27125, 0.335, 1.015, 0.335);
    private static final AxisAlignedBB INPUT_SLOT_AABB = new AxisAlignedBB(0.375, 0.86, 0.375, 0.625, 1.015, 0.625);

    private static SelectionPlace getPlayerSelection(World world, BlockPos pos, EntityPlayer player) {
        double length = Math.sqrt(pos.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v)) + 1.5;
        Vec3d eyePos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d lookingPos = eyePos.func_178787_e(new Vec3d(player.func_70040_Z().field_72450_a * length, player.func_70040_Z().field_72448_b * length, player.func_70040_Z().field_72449_c * length));
        TEQuern teQuern = Helpers.getTE((IBlockAccess)world, pos, TEQuern.class);
        if (teQuern != null) {
            IItemHandler inventory = (IItemHandler)teQuern.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (!teQuern.isGrinding() && teQuern.hasHandstone() && HANDLE_AABB.func_186670_a(pos).func_72327_a(eyePos, lookingPos) != null) {
                return SelectionPlace.HANDLE;
            }
            if (!teQuern.isGrinding() && teQuern.hasHandstone() && (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() || inventory != null && !inventory.getStackInSlot(1).func_190926_b()) && INPUT_SLOT_AABB.func_186670_a(pos).func_72327_a(eyePos, lookingPos) != null) {
                return SelectionPlace.INPUT_SLOT;
            }
            if ((teQuern.hasHandstone() || teQuern.isItemValid(0, player.func_184586_b(EnumHand.MAIN_HAND))) && HANDSTONE_AABB.func_186670_a(pos).func_72327_a(eyePos, lookingPos) != null) {
                return SelectionPlace.HANDSTONE;
            }
        }
        return SelectionPlace.BASE;
    }

    public BlockQuern() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.VERY_LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TEQuern teQuern = Helpers.getTE(source, pos, TEQuern.class);
        if (teQuern != null && teQuern.hasHandstone()) {
            return QUERN_AABB;
        }
        return BASE_AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockQuern.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        TEQuern teQuern = Helpers.getTE((IBlockAccess)world, pos, TEQuern.class);
        if (teQuern != null && teQuern.hasHandstone()) {
            BlockQuern.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HANDSTONE_AABB);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TEQuern teQuern = Helpers.getTE((IBlockAccess)world, pos, TEQuern.class);
        if (teQuern != null) {
            teQuern.onBreakBlock(world, pos, state);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TEQuern teQuern;
        if (hand.equals((Object)EnumHand.MAIN_HAND) && (teQuern = Helpers.getTE((IBlockAccess)world, pos, TEQuern.class)) != null && !teQuern.isGrinding()) {
            ItemStack heldStack = playerIn.func_184586_b(hand);
            SelectionPlace selection = BlockQuern.getPlayerSelection(world, pos, playerIn);
            IItemHandler inventory = (IItemHandler)teQuern.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (inventory != null) {
                if (selection == SelectionPlace.HANDLE) {
                    teQuern.grind();
                    world.func_184133_a(null, pos, TFCSounds.QUERN_USE, SoundCategory.BLOCKS, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 16.0f);
                    return true;
                }
                if (selection == SelectionPlace.INPUT_SLOT) {
                    playerIn.func_184611_a(EnumHand.MAIN_HAND, teQuern.insertOrSwapItem(1, heldStack));
                    teQuern.setAndUpdateSlots(1);
                    return true;
                }
                if (selection == SelectionPlace.HANDSTONE && inventory.getStackInSlot(0).func_190926_b() && inventory.isItemValid(0, heldStack)) {
                    playerIn.func_184611_a(EnumHand.MAIN_HAND, teQuern.insertOrSwapItem(0, heldStack));
                    teQuern.setAndUpdateSlots(0);
                    return true;
                }
                if (selection == SelectionPlace.BASE && !inventory.getStackInSlot(2).func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)inventory.extractItem(2, inventory.getStackInSlot(2).func_190916_E(), false));
                    teQuern.setAndUpdateSlots(2);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEQuern();
    }

    @Override
    public boolean drawHighlight(World world, BlockPos pos, EntityPlayer player, RayTraceResult rayTrace, double partialTicks) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        SelectionPlace selection = BlockQuern.getPlayerSelection(world, pos, player);
        if (selection == SelectionPlace.HANDLE) {
            IHighlightHandler.drawBox(HANDLE_AABB.func_186670_a(pos).func_72317_d(-dx, -dy, -dz), 1.0f, 0.0f, 0.0f, 0.0f, 0.4f);
        } else if (selection == SelectionPlace.INPUT_SLOT) {
            IHighlightHandler.drawBox(INPUT_SLOT_AABB.func_186670_a(pos).func_72317_d(-dx, -dy, -dz), 1.0f, 0.0f, 0.0f, 0.0f, 0.4f);
        } else if (selection == SelectionPlace.HANDSTONE) {
            IHighlightHandler.drawBox(HANDSTONE_AABB.func_186670_a(pos).func_72317_d(-dx, -dy, -dz).func_186662_g(0.002), 1.0f, 0.0f, 0.0f, 0.0f, 0.4f);
        } else {
            IHighlightHandler.drawBox(BASE_AABB.func_186670_a(pos).func_72317_d(-dx, -dy, -dz).func_186662_g(0.002), 1.0f, 0.0f, 0.0f, 0.0f, 0.4f);
        }
        return true;
    }

    private static enum SelectionPlace {
        HANDLE,
        HANDSTONE,
        INPUT_SLOT,
        BASE;

    }
}

