/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TEBloomery;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.block.Multiblock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockBloomery
extends BlockHorizontal
implements IItemSize,
ILightableBlock {
    private static final AxisAlignedBB[][] AABB = new AxisAlignedBB[][]{{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 0.5), new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 0.5)}, {new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.5, 0.0, 0.875, 1.0, 1.0, 1.0)}, {new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.5, 0.125, 1.0, 1.0), new AxisAlignedBB(0.875, 0.0, 0.5, 1.0, 1.0, 1.0)}, {new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.125), new AxisAlignedBB(0.0, 0.0, 0.875, 0.5, 1.0, 1.0)}};
    private static final Multiblock BLOOMERY_CHIMNEY;
    private static final Multiblock[] BLOOMERY_BASE;
    private static final Multiblock GATE_Z;
    private static final Multiblock GATE_X;

    public static boolean isValidSideBlock(IBlockState state) {
        return state.func_185904_a() == Material.field_151576_e && state.func_185915_l();
    }

    public static int getChimneyLevels(World world, BlockPos centerPos) {
        for (int i = 1; i < 4; ++i) {
            BlockPos center = centerPos.func_177981_b(i);
            if (BLOOMERY_CHIMNEY.test(world, center)) continue;
            return i - 1;
        }
        return 3;
    }

    public BlockBloomery() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(20.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canGateStayInPlace(World world, BlockPos pos, EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return GATE_X.test(world, pos);
        }
        return GATE_Z.test(world, pos);
    }

    public boolean isFormed(World world, BlockPos centerPos, EnumFacing facing) {
        return BLOOMERY_BASE[facing.func_176736_b()].test(world, centerPos);
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta / 4 % 2 != 0)).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(meta / 8 != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b) != false ? 8 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b()][0];
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue()) {
            return field_185506_k;
        }
        return AABB[((EnumFacing)blockState.func_177229_b((IProperty)field_185512_D)).func_176736_b()][0];
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEBloomery te = Helpers.getTE((IBlockAccess)worldIn, pos, TEBloomery.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        if (((Boolean)blockState.func_177229_b((IProperty)BlockTrapDoor.field_176283_b)).booleanValue()) {
            int index = ((EnumFacing)blockState.func_177229_b((IProperty)field_185512_D)).func_176736_b();
            RayTraceResult rayTraceDoor1 = this.func_185503_a(pos, start, end, AABB[index][1]);
            RayTraceResult rayTraceDoor2 = this.func_185503_a(pos, start, end, AABB[index][2]);
            if (rayTraceDoor1 == null) {
                return rayTraceDoor2;
            }
            if (rayTraceDoor2 == null) {
                return rayTraceDoor1;
            }
            if (rayTraceDoor1.field_72307_f.func_72436_e(end) > rayTraceDoor2.field_72307_f.func_72436_e(end)) {
                return rayTraceDoor1;
            }
            return rayTraceDoor2;
        }
        return super.func_180636_a(blockState, worldIn, pos, start, end);
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (this.canGateStayInPlace(worldIn, pos, EnumFacing.Axis.Z) || this.canGateStayInPlace(worldIn, pos, EnumFacing.Axis.X));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack held;
            TEBloomery te;
            if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                worldIn.func_175656_a(pos, state.func_177231_a((IProperty)BlockTrapDoor.field_176283_b));
                worldIn.func_184133_a(null, pos, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if ((te = Helpers.getTE((IBlockAccess)worldIn, pos, TEBloomery.class)) != null && !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && te.canIgnite() && ItemFireStarter.onIgnition(held = player.func_184586_b(hand))) {
                TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(false)));
                te.onIgnite();
                return true;
            }
        }
        return true;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing placeDirection;
        float wrappedRotation = MathHelper.func_76142_g((float)placer.field_70177_z);
        if (this.canGateStayInPlace(worldIn, pos, EnumFacing.Axis.X)) {
            placeDirection = wrappedRotation < 0.0f ? EnumFacing.EAST : EnumFacing.WEST;
        } else if (this.canGateStayInPlace(worldIn, pos, EnumFacing.Axis.Z)) {
            placeDirection = wrappedRotation > 90.0f || wrappedRotation < -90.0f ? EnumFacing.NORTH : EnumFacing.SOUTH;
        } else {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placeDirection);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, LIT, BlockTrapDoor.field_176283_b});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEBloomery();
    }

    static {
        Predicate<IBlockState> stoneMatcher = BlockBloomery::isValidSideBlock;
        Predicate<IBlockState> insideChimney = state -> state.func_177230_c() == BlocksTFC.MOLTEN || state.func_185904_a().func_76222_j();
        Predicate<IBlockState> center = state -> state.func_177230_c() == BlocksTFC.CHARCOAL_PILE || state.func_177230_c() == BlocksTFC.BLOOM || state.func_185904_a().func_76222_j();
        BLOOMERY_BASE = new Multiblock[4];
        BlockBloomery.BLOOMERY_BASE[EnumFacing.NORTH.func_176736_b()] = new Multiblock().match(new BlockPos(0, 0, 0), center).match(new BlockPos(0, -1, 0), stoneMatcher).match(new BlockPos(0, 0, 1), state -> state.func_177230_c() == BlocksTFC.BLOOMERY).match(new BlockPos(1, 0, 1), stoneMatcher).match(new BlockPos(-1, 0, 1), stoneMatcher).match(new BlockPos(0, 1, 1), stoneMatcher).match(new BlockPos(0, 1, -1), stoneMatcher).match(new BlockPos(1, 1, 0), stoneMatcher).match(new BlockPos(-1, 1, 0), stoneMatcher).match(new BlockPos(0, -1, 1), stoneMatcher).match(new BlockPos(0, 0, -1), stoneMatcher).match(new BlockPos(1, 0, 0), stoneMatcher).match(new BlockPos(-1, 0, 0), stoneMatcher);
        BlockBloomery.BLOOMERY_BASE[EnumFacing.SOUTH.func_176736_b()] = new Multiblock().match(new BlockPos(0, 0, 0), center).match(new BlockPos(0, -1, 0), stoneMatcher).match(new BlockPos(0, 0, -1), state -> state.func_177230_c() == BlocksTFC.BLOOMERY).match(new BlockPos(1, 0, -1), stoneMatcher).match(new BlockPos(-1, 0, -1), stoneMatcher).match(new BlockPos(0, 1, 1), stoneMatcher).match(new BlockPos(0, 1, -1), stoneMatcher).match(new BlockPos(1, 1, 0), stoneMatcher).match(new BlockPos(-1, 1, 0), stoneMatcher).match(new BlockPos(0, -1, -1), stoneMatcher).match(new BlockPos(0, 0, 1), stoneMatcher).match(new BlockPos(1, 0, 0), stoneMatcher).match(new BlockPos(-1, 0, 0), stoneMatcher);
        BlockBloomery.BLOOMERY_BASE[EnumFacing.WEST.func_176736_b()] = new Multiblock().match(new BlockPos(0, 0, 0), center).match(new BlockPos(0, -1, 0), stoneMatcher).match(new BlockPos(1, 0, 0), state -> state.func_177230_c() == BlocksTFC.BLOOMERY).match(new BlockPos(1, 0, -1), stoneMatcher).match(new BlockPos(1, 0, 1), stoneMatcher).match(new BlockPos(0, 1, 1), stoneMatcher).match(new BlockPos(0, 1, -1), stoneMatcher).match(new BlockPos(1, 1, 0), stoneMatcher).match(new BlockPos(-1, 1, 0), stoneMatcher).match(new BlockPos(1, -1, 0), stoneMatcher).match(new BlockPos(0, 0, 1), stoneMatcher).match(new BlockPos(0, 0, -1), stoneMatcher).match(new BlockPos(-1, 0, 0), stoneMatcher);
        BlockBloomery.BLOOMERY_BASE[EnumFacing.EAST.func_176736_b()] = new Multiblock().match(new BlockPos(0, 0, 0), center).match(new BlockPos(0, -1, 0), stoneMatcher).match(new BlockPos(-1, 0, 0), state -> state.func_177230_c() == BlocksTFC.BLOOMERY).match(new BlockPos(-1, 0, -1), stoneMatcher).match(new BlockPos(-1, 0, 1), stoneMatcher).match(new BlockPos(0, 1, 1), stoneMatcher).match(new BlockPos(0, 1, -1), stoneMatcher).match(new BlockPos(1, 1, 0), stoneMatcher).match(new BlockPos(-1, 1, 0), stoneMatcher).match(new BlockPos(-1, -1, 0), stoneMatcher).match(new BlockPos(0, 0, 1), stoneMatcher).match(new BlockPos(0, 0, -1), stoneMatcher).match(new BlockPos(1, 0, 0), stoneMatcher);
        BLOOMERY_CHIMNEY = new Multiblock().match(new BlockPos(0, 0, 0), insideChimney).match(new BlockPos(1, 0, 0), stoneMatcher).match(new BlockPos(-1, 0, 0), stoneMatcher).match(new BlockPos(0, 0, 1), stoneMatcher).match(new BlockPos(0, 0, -1), stoneMatcher);
        GATE_Z = new Multiblock().match(new BlockPos(0, 0, 0), state -> state.func_177230_c() == BlocksTFC.BLOOMERY || state.func_177230_c() == Blocks.field_150350_a).match(new BlockPos(1, 0, 0), stoneMatcher).match(new BlockPos(-1, 0, 0), stoneMatcher).match(new BlockPos(0, 1, 0), stoneMatcher).match(new BlockPos(0, -1, 0), stoneMatcher);
        GATE_X = new Multiblock().match(new BlockPos(0, 0, 0), state -> state.func_177230_c() == BlocksTFC.BLOOMERY || state.func_177230_c() == Blocks.field_150350_a).match(new BlockPos(0, 0, 1), stoneMatcher).match(new BlockPos(0, 0, -1), stoneMatcher).match(new BlockPos(0, 1, 0), stoneMatcher).match(new BlockPos(0, -1, 0), stoneMatcher);
    }
}

