/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.util.IBellowsConsumerBlock;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlockFireBrick;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.metal.BlockMetalSheet;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TEBellows;
import net.dries007.tfc.objects.te.TEBlastFurnace;
import net.dries007.tfc.objects.te.TEMetalSheet;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.block.Multiblock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockBlastFurnace
extends Block
implements IBellowsConsumerBlock,
ILightableBlock {
    private static final Multiblock BLAST_FURNACE_CHIMNEY;

    public static int getChimneyLevels(World world, BlockPos pos) {
        for (int i = 1; i < 6; ++i) {
            BlockPos center = pos.func_177981_b(i);
            if (BLAST_FURNACE_CHIMNEY.test(world, center)) continue;
            return i - 1;
        }
        return 5;
    }

    public BlockBlastFurnace() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEBlastFurnace te = Helpers.getTE((IBlockAccess)worldIn, pos, TEBlastFurnace.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                TEBlastFurnace te = Helpers.getTE((IBlockAccess)worldIn, pos, TEBlastFurnace.class);
                if (te == null) {
                    return true;
                }
                ItemStack held = playerIn.func_184586_b(hand);
                if (te.canIgnite() && ItemFireStarter.onIgnition(held)) {
                    TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)playerIn, state.func_177230_c());
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                    return true;
                }
            }
            if (!playerIn.func_70093_af()) {
                TFCGuiHandler.openGui(worldIn, pos, playerIn, TFCGuiHandler.Type.BLAST_FURNACE);
            }
        }
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEBlastFurnace();
    }

    @Override
    public boolean canIntakeFrom(@Nonnull TEBellows te, @Nonnull Vec3i offset, @Nonnull EnumFacing facing) {
        return offset.equals((Object)TEBellows.OFFSET_LEVEL);
    }

    @Override
    public void onAirIntake(@Nonnull TEBellows te, @Nonnull World world, @Nonnull BlockPos pos, int airAmount) {
        TEBlastFurnace teBlastFurnace = Helpers.getTE((IBlockAccess)world, pos, TEBlastFurnace.class);
        if (teBlastFurnace != null) {
            teBlastFurnace.onAirIntake(airAmount);
        }
    }

    static {
        Predicate<IBlockState> stoneMatcher = state -> state.func_177230_c() instanceof BlockFireBrick;
        Predicate<IBlockState> sheetMatcher = state -> {
            if (state.func_177230_c() instanceof BlockMetalSheet) {
                BlockMetalSheet block = (BlockMetalSheet)state.func_177230_c();
                return block.getMetal().getTier().isAtLeast(Metal.Tier.TIER_III) && block.getMetal().isToolMetal();
            }
            return false;
        };
        BLAST_FURNACE_CHIMNEY = new Multiblock().match(new BlockPos(0, 0, 0), state -> state.func_177230_c() == BlocksTFC.MOLTEN || state.func_185904_a().func_76222_j()).match(new BlockPos(0, 0, 1), stoneMatcher).match(new BlockPos(0, 0, -1), stoneMatcher).match(new BlockPos(1, 0, 0), stoneMatcher).match(new BlockPos(-1, 0, 0), stoneMatcher).match(new BlockPos(0, 0, -2), sheetMatcher).match(new BlockPos(0, 0, -2), tile -> tile.getFace(EnumFacing.NORTH), TEMetalSheet.class).match(new BlockPos(0, 0, 2), sheetMatcher).match(new BlockPos(0, 0, 2), tile -> tile.getFace(EnumFacing.SOUTH), TEMetalSheet.class).match(new BlockPos(2, 0, 0), sheetMatcher).match(new BlockPos(2, 0, 0), tile -> tile.getFace(EnumFacing.EAST), TEMetalSheet.class).match(new BlockPos(-2, 0, 0), sheetMatcher).match(new BlockPos(-2, 0, 0), tile -> tile.getFace(EnumFacing.WEST), TEMetalSheet.class).match(new BlockPos(-1, 0, -1), sheetMatcher).match(new BlockPos(-1, 0, -1), tile -> tile.getFace(EnumFacing.NORTH) && tile.getFace(EnumFacing.WEST), TEMetalSheet.class).match(new BlockPos(1, 0, -1), sheetMatcher).match(new BlockPos(1, 0, -1), tile -> tile.getFace(EnumFacing.NORTH) && tile.getFace(EnumFacing.EAST), TEMetalSheet.class).match(new BlockPos(-1, 0, 1), sheetMatcher).match(new BlockPos(-1, 0, 1), tile -> tile.getFace(EnumFacing.SOUTH) && tile.getFace(EnumFacing.WEST), TEMetalSheet.class).match(new BlockPos(1, 0, 1), sheetMatcher).match(new BlockPos(1, 0, 1), tile -> tile.getFace(EnumFacing.SOUTH) && tile.getFace(EnumFacing.EAST), TEMetalSheet.class);
    }
}

