/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeLeaves;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeTrunk;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockFruitTreeSapling
extends BlockBush
implements IGrowable {
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.9, 0.9);
    private static final Map<IFruitTree, BlockFruitTreeSapling> MAP = new HashMap<IFruitTree, BlockFruitTreeSapling>();
    private final IFruitTree tree;

    public static BlockFruitTreeSapling get(IFruitTree tree) {
        return MAP.get(tree);
    }

    public BlockFruitTreeSapling(IFruitTree tree) {
        if (MAP.put(tree, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.tree = tree;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149675_a(true);
        OreDictionaryHelper.register((Block)this, "tree", "sapling");
        OreDictionaryHelper.register((Block)this, "tree", "sapling", tree.getName());
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        TETickCounter te;
        super.func_180650_b(world, pos, state, random);
        if (!world.field_72995_K && (te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class)) != null) {
            float temp = ClimateTFC.getActualTemp(world, pos);
            float rainfall = ChunkDataTFC.getRainfall(world, pos);
            long hours = te.getTicksSinceUpdate() / 1000L;
            if ((double)hours > (double)this.tree.getGrowthTime() * ConfigTFC.General.FOOD.fruitTreeGrowthTimeModifier && this.tree.isValidForGrowth(temp, rainfall)) {
                te.resetCounter();
                this.func_176474_b(world, random, pos, state);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TETickCounter te = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (te != null) {
            te.resetCounter();
        }
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TETickCounter();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public boolean func_176473_a(World world, BlockPos blockPos, IBlockState iBlockState, boolean b) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, IBlockState iBlockState) {
        return true;
    }

    public void func_176474_b(World world, Random random, BlockPos blockPos, IBlockState blockState) {
        if (!world.field_72995_K) {
            world.func_175656_a(blockPos, BlockFruitTreeTrunk.get(this.tree).func_176223_P());
            if (world.func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76222_j()) {
                world.func_175656_a(blockPos.func_177984_a(), BlockFruitTreeLeaves.get(this.tree).func_176223_P().func_177226_a((IProperty)BlockFruitTreeLeaves.HARVESTABLE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Nonnull
    public IFruitTree getTree() {
        return this.tree;
    }
}

