/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.util.agriculture.Crop;
import net.dries007.tfc.util.skills.SimpleSkill;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public abstract class BlockCropSimple
extends BlockCropTFC {
    private final boolean isPickable;

    public static BlockCropSimple create(ICrop crop, boolean isPickable) {
        final PropertyInteger property = BlockCropSimple.getStagePropertyForCrop(crop);
        if (property == null) {
            throw new IllegalStateException("Invalid growthstage property " + (crop.getMaxStage() + 1) + " for crop");
        }
        return new BlockCropSimple(crop, isPickable){

            @Override
            public PropertyInteger getStageProperty() {
                return property;
            }
        };
    }

    protected BlockCropSimple(ICrop crop, boolean isPickable) {
        super(crop);
        this.isPickable = isPickable;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.getStageProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WILD, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void grow(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (!worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)this.getStageProperty()) < this.getCrop().getMaxStage()) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.getStageProperty(), (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)this.getStageProperty()) + 1)), 2);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack foodDrop;
        if (this.isPickable && !(foodDrop = this.getCrop().getFoodDrop((Integer)state.func_177229_b((IProperty)this.getStageProperty()))).func_190926_b()) {
            ItemStack seedDrop = new ItemStack((Item)ItemSeedsTFC.get(this.getCrop()), 0);
            SimpleSkill skill = CapabilityPlayerData.getSkill(playerIn, SkillType.AGRICULTURE);
            if (skill != null) {
                foodDrop.func_190920_e(1 + Crop.getSkillFoodBonus(skill, RANDOM));
                seedDrop.func_190920_e(Crop.getSkillSeedBonus(skill, RANDOM));
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)this.getStageProperty(), (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)this.getStageProperty()) - 3)));
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)foodDrop);
                if (!seedDrop.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)seedDrop);
                }
            }
            return true;
        }
        return false;
    }
}

