/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockPlanksTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockStairsTFC
extends BlockStairs {
    private static final Map<Rock, EnumMap<Rock.Type, BlockStairsTFC>> ROCK_TABLE = new HashMap<Rock, EnumMap<Rock.Type, BlockStairsTFC>>();
    private static final Map<Tree, BlockStairsTFC> WOOD_MAP = new HashMap<Tree, BlockStairsTFC>();

    public static BlockStairsTFC get(Rock rock, Rock.Type type) {
        return ROCK_TABLE.get((Object)rock).get((Object)type);
    }

    public static BlockStairsTFC get(Tree wood) {
        return WOOD_MAP.get((Object)wood);
    }

    public BlockStairsTFC(Rock rock, Rock.Type type) {
        super(BlockRockVariant.get(rock, type).func_176223_P());
        if (!ROCK_TABLE.containsKey((Object)rock)) {
            ROCK_TABLE.put(rock, new EnumMap(Rock.Type.class));
        }
        ROCK_TABLE.get((Object)rock).put(type, this);
        BlockRockVariant baseBlock = BlockRockVariant.get(rock, type);
        this.setHarvestLevel(baseBlock.getHarvestTool(baseBlock.func_176223_P()), baseBlock.getHarvestLevel(baseBlock.func_176223_P()));
        this.field_149783_u = true;
        OreDictionaryHelper.register((Block)this, "stair");
        OreDictionaryHelper.registerRockType((Block)this, type, "stair");
    }

    public BlockStairsTFC(Tree wood) {
        super(BlockPlanksTFC.get(wood).func_176223_P());
        if (WOOD_MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        BlockPlanksTFC baseBlock = BlockPlanksTFC.get(wood);
        this.setHarvestLevel(baseBlock.getHarvestTool(baseBlock.func_176223_P()), baseBlock.getHarvestLevel(baseBlock.func_176223_P()));
        this.field_149783_u = true;
        OreDictionaryHelper.register((Block)this, "stair");
        OreDictionaryHelper.register((Block)this, "stair", "wood");
        OreDictionaryHelper.register((Block)this, new Object[]{"stair", "wood", wood});
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, IBlockState state) {
    }
}

