/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockPlanksTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BlockSlabTFC
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    public final Block modelBlock;
    protected Half halfSlab;

    private BlockSlabTFC(Rock rock, Rock.Type type) {
        this(BlockRockVariant.get(rock, type));
        BlockRockVariant c = BlockRockVariant.get(rock, type);
        this.setHarvestLevel(c.getHarvestTool(c.func_176223_P()), c.getHarvestLevel(c.func_176223_P()));
        this.field_149783_u = true;
    }

    private BlockSlabTFC(Tree wood) {
        this(BlockPlanksTFC.get(wood));
        BlockPlanksTFC c = BlockPlanksTFC.get(wood);
        this.setHarvestLevel(c.getHarvestTool(c.func_176223_P()), c.getHarvestLevel(c.func_176223_P()));
        this.field_149783_u = true;
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    private BlockSlabTFC(Block block) {
        super(block.func_176223_P().func_185904_a());
        IBlockState state = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            state = state.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(state.func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
        this.modelBlock = block;
        this.func_149713_g(255);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.modelBlock.func_176195_g(blockState, worldIn, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.halfSlab);
    }

    public float func_149638_a(Entity exploder) {
        return this.modelBlock.func_149638_a(exploder);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this.halfSlab);
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public SoundType func_185467_w() {
        return this.modelBlock.func_185467_w();
    }

    public static class Half
    extends BlockSlabTFC {
        private static final Map<Rock, EnumMap<Rock.Type, Half>> ROCK_TABLE = new HashMap<Rock, EnumMap<Rock.Type, Half>>();
        private static final Map<Tree, Half> WOOD_MAP = new HashMap<Tree, Half>();
        public final Double doubleSlab;

        public static Half get(Rock rock, Rock.Type type) {
            return ROCK_TABLE.get((Object)rock).get((Object)type);
        }

        public static Half get(Tree wood) {
            return WOOD_MAP.get((Object)wood);
        }

        public Half(Rock rock, Rock.Type type) {
            super(rock, type);
            if (!ROCK_TABLE.containsKey((Object)rock)) {
                ROCK_TABLE.put(rock, new EnumMap(Rock.Type.class));
            }
            ROCK_TABLE.get((Object)rock).put(type, this);
            this.doubleSlab = Double.get(rock, type);
            this.doubleSlab.halfSlab = this;
            this.halfSlab = this;
            OreDictionaryHelper.register((Block)this, "slab");
            OreDictionaryHelper.registerRockType((Block)this, type, "slab");
        }

        public Half(Tree wood) {
            super(wood);
            if (WOOD_MAP.put(wood, this) != null) {
                throw new IllegalStateException("There can only be one.");
            }
            this.doubleSlab = Double.get(wood);
            this.doubleSlab.halfSlab = this;
            this.halfSlab = this;
            OreDictionaryHelper.register((Block)this, "slab");
            OreDictionaryHelper.register((Block)this, "slab", "wood");
            OreDictionaryHelper.register((Block)this, new Object[]{"slab", "wood", wood});
        }

        public boolean func_176552_j() {
            return false;
        }
    }

    public static class Double
    extends BlockSlabTFC {
        private static final Map<Rock, EnumMap<Rock.Type, Double>> ROCK_TABLE = new HashMap<Rock, EnumMap<Rock.Type, Double>>();
        private static final Map<Tree, Double> WOOD_MAP = new HashMap<Tree, Double>();

        public static Double get(Rock rock, Rock.Type type) {
            return ROCK_TABLE.get((Object)rock).get((Object)type);
        }

        public static Double get(Tree wood) {
            return WOOD_MAP.get((Object)wood);
        }

        public Double(Rock rock, Rock.Type type) {
            super(rock, type);
            if (!ROCK_TABLE.containsKey((Object)rock)) {
                ROCK_TABLE.put(rock, new EnumMap(Rock.Type.class));
            }
            ROCK_TABLE.get((Object)rock).put(type, this);
        }

        public Double(Tree wood) {
            super(wood);
            if (WOOD_MAP.put(wood, this) != null) {
                throw new IllegalStateException("There can only be one.");
            }
        }

        public boolean func_176552_j() {
            return true;
        }
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

