/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import com.google.common.primitives.Ints;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockFluidTFC
extends BlockFluidClassic {
    public BlockFluidTFC(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public BlockFluidTFC(Fluid fluid, Material material, boolean canCreateSources) {
        this(fluid, material);
        this.canCreateSources = canCreateSources;
        this.func_149711_c(100.0f);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        IBlockState newState = world.func_180495_p(pos);
        if (!this.isSourceBlock((IBlockAccess)world, pos)) {
            int minMeta = 100;
            int currentMeta = this.quantaPerBlock - 1;
            BlockFluidTFC blockType = this;
            if (newState.func_177230_c() == this) {
                currentMeta = (Integer)newState.func_177229_b((IProperty)LEVEL);
            }
            if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() != this) {
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    BlockPos neighborPos = pos.func_177972_a(side);
                    IBlockState neighborState = world.func_180495_p(neighborPos);
                    Block block = neighborState.func_177230_c();
                    if (!(block instanceof BlockFluidTFC)) continue;
                    BlockFluidTFC neighborBlock = (BlockFluidTFC)block;
                    Block neighborAboveBlock = world.func_180495_p(neighborPos.func_177979_c(this.densityDir)).func_177230_c();
                    int neighborMeta = neighborAboveBlock == neighborBlock ? 0 : (Integer)neighborState.func_177229_b((IProperty)LEVEL);
                    if (neighborMeta < minMeta) {
                        blockType = neighborBlock;
                        minMeta = neighborMeta;
                        continue;
                    }
                    if (neighborMeta != minMeta || neighborBlock.getDensity() <= blockType.getDensity() && (neighborBlock != this || neighborBlock.getDensity() < blockType.getDensity())) continue;
                    blockType = neighborBlock;
                }
            }
            if (minMeta + 1 < currentMeta && blockType != this) {
                world.func_180501_a(pos, blockType.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(currentMeta)), 3);
            }
        }
    }

    protected boolean[] getOptimalFlowDirections(World world, BlockPos pos) {
        for (int side = 0; side < 4; ++side) {
            this.flowCost[side] = 1000;
            BlockPos pos2 = pos.func_177972_a((EnumFacing)SIDES.get(side));
            if (!this.canFlowInto((IBlockAccess)world, pos2) || this.isBlockingSourceBlock((IBlockAccess)world, pos2)) continue;
            this.flowCost[side] = this.canFlowInto((IBlockAccess)world, pos2.func_177981_b(this.densityDir)) ? 0 : this.calculateFlowCost(world, pos2, 1, side);
        }
        int min = Ints.min((int[])this.flowCost);
        for (int side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(World world, BlockPos pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            BlockPos pos2;
            if (SIDES.get(adjSide) == ((EnumFacing)SIDES.get(side)).func_176734_d() || !this.canFlowInto((IBlockAccess)world, pos2 = pos.func_177972_a((EnumFacing)SIDES.get(adjSide))) || this.isBlockingSourceBlock((IBlockAccess)world, pos2)) continue;
            if (this.canFlowInto((IBlockAccess)world, pos2.func_177981_b(this.densityDir))) {
                return recurseDepth;
            }
            if (recurseDepth >= this.quantaPerBlock / 2) continue;
            cost = Math.min(cost, this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide));
        }
        return cost;
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            boolean replace;
            IBlockState targetBlockState = world.func_180495_p(pos);
            Block targetBlock = targetBlockState.func_177230_c();
            boolean bl = replace = !(targetBlock instanceof BlockFluidBase);
            if (targetBlock instanceof BlockFluidTFC) {
                if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == this) {
                    replace = true;
                }
                int blockFlowStrength = (Integer)targetBlockState.func_177229_b((IProperty)LEVEL);
                if (!replace) {
                    boolean supported = false;
                    if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == targetBlock) {
                        supported = true;
                    }
                    if (!supported) {
                        for (EnumFacing side : EnumFacing.field_176754_o) {
                            IBlockState neighbor = world.func_180495_p(pos.func_177972_a(side));
                            if (neighbor.func_177230_c() != targetBlock || blockFlowStrength <= (Integer)neighbor.func_177229_b((IProperty)LEVEL) && world.func_180495_p(pos.func_177972_a(side).func_177979_c(this.densityDir)).func_177230_c() != targetBlock) continue;
                            supported = true;
                            break;
                        }
                    }
                    boolean bl2 = replace = !supported;
                }
                if (!replace) {
                    int flowStrength = blockFlowStrength;
                    if (((BlockFluidTFC)targetBlock).getDensity() > this.getDensity()) {
                        ++flowStrength;
                    }
                    if (flowStrength > meta) {
                        replace = true;
                    }
                }
            }
            if (replace) {
                world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
            }
        }
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return super.canFlowInto(world, pos) || state.func_185904_a().func_76224_d();
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, world, pos)) {
            return true;
        }
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E || material == Material.field_189963_J) {
            return false;
        }
        if (block instanceof BlockFluidTFC) {
            return (Integer)state.func_177229_b((IProperty)LEVEL) != 0;
        }
        int density = BlockFluidTFC.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState oldState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        int j;
        int i;
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty((IUnlistedProperty)FLOW_DIRECTION, (Object)Float.valueOf((float)BlockFluidTFC.getFlowDirection((IBlockAccess)world, (BlockPos)pos)));
        IBlockState[][] upBlockState = new IBlockState[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        upBlockState[1][1] = world.func_180495_p(pos.func_177979_c(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(world, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = 1.0f;
                }
            }
        } else {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    if (i == 1 && j == 1) continue;
                    upBlockState[i][j] = world.func_180495_p(pos.func_177982_a(i - 1, 0, j - 1).func_177979_c(this.densityDir));
                    height[i][j] = this.getFluidHeightForRender(world, pos.func_177982_a(i - 1, 0, j - 1), upBlockState[i][j]);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    corner[i][j] = this.getFluidHeightAverage(new float[]{height[i][j], height[i][j + 1], height[i + 1][j], height[i + 1][j + 1]});
                }
            }
            boolean n = this.isMergeableFluid(upBlockState[0][1]);
            boolean s = this.isMergeableFluid(upBlockState[2][1]);
            boolean w = this.isMergeableFluid(upBlockState[1][0]);
            boolean e = this.isMergeableFluid(upBlockState[1][2]);
            boolean nw = this.isMergeableFluid(upBlockState[0][0]);
            boolean ne = this.isMergeableFluid(upBlockState[0][2]);
            boolean sw = this.isMergeableFluid(upBlockState[2][0]);
            boolean se = this.isMergeableFluid(upBlockState[2][2]);
            if (nw || n || w) {
                corner[0][0] = 1.0f;
            }
            if (ne || n || e) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e) {
                corner[1][1] = 1.0f;
            }
        }
        for (i = 0; i < 4; ++i) {
            EnumFacing side = EnumFacing.func_176731_b((int)i);
            BlockPos offset = pos.func_177972_a(side);
            boolean useOverlay = world.func_180495_p(offset).func_193401_d(world, offset, side.func_176734_d()) == BlockFaceShape.SOLID;
            state = state.withProperty((IUnlistedProperty)SIDE_OVERLAYS[i], (Object)useOverlay);
        }
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[0], (Object)Float.valueOf(corner[0][0]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[1], (Object)Float.valueOf(corner[0][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[2], (Object)Float.valueOf(corner[1][1]));
        state = state.withProperty((IUnlistedProperty)LEVEL_CORNERS[3], (Object)Float.valueOf(corner[1][0]));
        return state;
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos adjPos, @Nonnull IBlockState upState) {
        IBlockState adjState = world.func_180495_p(adjPos);
        if (this.isMergeableFluid(upState)) {
            return 1.0f;
        }
        if (this.isMergeableFluid(adjState)) {
            Block adjBlock = adjState.func_177230_c();
            if (adjBlock == this || adjBlock instanceof BlockLiquid) {
                return super.getFluidHeightForRender(world, adjPos, upState);
            }
            return ((BlockFluidBase)adjBlock).getFluidHeightForRender(world, adjPos, upState);
        }
        if (adjState.func_185904_a().func_76220_a()) {
            return -1.0f;
        }
        return 0.0f;
    }

    protected boolean isMergeableFluid(@Nonnull IBlockState blockstate) {
        return blockstate.func_185904_a() == this.func_176223_P().func_185904_a() && blockstate.func_185904_a().func_76224_d();
    }

    protected boolean isBlockingSourceBlock(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.isMergeableFluid(state) && (Integer)state.func_177229_b((IProperty)LEVEL) == 0;
    }
}

