/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LitTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("tfc", "lit_device");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add((ICriterionTrigger.Listener<Instance>)listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove((ICriterionTrigger.Listener<Instance>)listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ResourceLocation resourceLocation = null;
        JsonElement element = json.get("block");
        if (element != null && !element.isJsonNull()) {
            resourceLocation = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)element, (String)"block"));
        }
        return new Instance(resourceLocation);
    }

    public void trigger(EntityPlayerMP player, Block block) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(block);
        }
    }

    private static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        private Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        private boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        private void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        private void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        private void trigger(Block block) {
            this.listeners.stream().filter(listener -> ((Instance)listener.func_192158_a()).test(block)).collect(Collectors.toList()).forEach(listener -> listener.func_192159_a(this.playerAdvancements));
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ResourceLocation blockPredicate;

        public Instance(@Nullable ResourceLocation blockPredicate) {
            super(ID);
            this.blockPredicate = blockPredicate;
        }

        public boolean test(Block block) {
            return this.blockPredicate == null || this.blockPredicate.equals((Object)block.getRegistryName());
        }
    }
}

