/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FamiliarizationTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("tfc", "familiarity_changed");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add((ICriterionTrigger.Listener<Instance>)listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove((ICriterionTrigger.Listener<Instance>)listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ResourceLocation resourceLocation = null;
        float familiarity = 0.0f;
        JsonElement animalElement = json.get("animal");
        JsonElement familiarityElement = json.get("familiarity");
        if (animalElement != null && !animalElement.isJsonNull()) {
            resourceLocation = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)animalElement, (String)"animal"));
        }
        if (familiarityElement != null && !familiarityElement.isJsonNull()) {
            familiarity = JsonUtils.func_151220_d((JsonElement)familiarityElement, (String)"familiarity");
        }
        return new Instance(resourceLocation, familiarity);
    }

    public <T extends EntityAnimal> void trigger(EntityPlayerMP player, T animal) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(animal);
        }
    }

    private static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        private Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        private boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        private void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        private void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        private <T extends EntityAnimal> void trigger(T animal) {
            this.listeners.stream().filter(listener -> ((Instance)listener.func_192158_a()).test(animal)).collect(Collectors.toList()).forEach(listener -> listener.func_192159_a(this.playerAdvancements));
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ResourceLocation animalPredicate;
        private final float minFamiliarity;

        public Instance(@Nullable ResourceLocation animalPredicate, float minFamiliarity) {
            super(ID);
            this.animalPredicate = animalPredicate;
            this.minFamiliarity = minFamiliarity;
        }

        public <T extends EntityAnimal> boolean test(@Nonnull T animal) {
            if (this.animalPredicate != null && !this.animalPredicate.equals((Object)EntityRegistry.getEntry(animal.getClass()).getRegistryName())) {
                return false;
            }
            return ((IAnimalTFC)animal).getFamiliarity() >= this.minFamiliarity;
        }
    }
}

