/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSaplingTFC) {
            BlockSaplingTFC block = (BlockSaplingTFC)state.func_177230_c();
            Tree wood = block.getWood();
            TETickCounter te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class);
            if (te != null) {
                long days = te.getTicksSinceUpdate() / 24000L;
                float perc = Math.min(0.99f, (float)days / wood.getMinGrowthTime()) * 100.0f;
                String growth = String.format("%d%%", Math.round(perc));
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growth", new Object[]{growth}).func_150254_d());
            }
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return Collections.singletonList(BlockSaplingTFC.class);
    }
}

