/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.te.TEPitKiln;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PitKilnProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        TEPitKiln te = Helpers.getTE((IBlockAccess)world, pos, TEPitKiln.class);
        if (te != null) {
            boolean isLit = te.isLit();
            if (isLit) {
                long remainingTicks = (long)ConfigTFC.Devices.PIT_KILN.ticks - (CalendarTFC.PLAYER_TIME.getTicks() - te.getLitTick());
                switch (ConfigTFC.Client.TOOLTIP.timeTooltipMode) {
                    case NONE: {
                        break;
                    }
                    case TICKS: {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.devices.ticks_remaining", new Object[]{remainingTicks}).func_150254_d());
                        break;
                    }
                    case MINECRAFT_HOURS: {
                        long remainingHours = Math.round((float)remainingTicks / 1000.0f);
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.devices.hours_remaining", new Object[]{remainingHours}).func_150254_d());
                        break;
                    }
                    case REAL_MINUTES: {
                        long remainingMinutes = Math.round((float)remainingTicks / 1200.0f);
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.devices.minutes_remaining", new Object[]{remainingMinutes}).func_150254_d());
                    }
                }
            } else {
                int straw = te.getStrawCount();
                int logs = te.getLogCount();
                if (straw == 8 && logs == 8) {
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.pitkiln.unlit", new Object[0]).func_150254_d());
                } else {
                    if (straw < 8) {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.pitkiln.straw", new Object[]{8 - straw}).func_150254_d());
                    }
                    if (logs < 8) {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.pitkiln.logs", new Object[]{8 - logs}).func_150254_d());
                    }
                }
            }
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return Collections.singletonList(TEPitKiln.class);
    }
}

