/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeBranch;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeLeaves;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeSapling;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeTrunk;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitTreeProvider
implements IWailaBlock {
    private static void addInfo(IFruitTree tree, TETickCounter te, float temperature, float rainfall, List<String> currentTooltip) {
        if (tree.isValidForGrowth(temperature, rainfall)) {
            currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growing", new Object[0]).func_150254_d());
            if (te != null) {
                long hours = te.getTicksSinceUpdate() / 1000L;
                float perc = Math.min(0.99f, (float)hours / (tree.getGrowthTime() * (float)ConfigTFC.General.FOOD.fruitTreeGrowthTimeModifier)) * 100.0f;
                String growth = String.format("%d%%", Math.round(perc));
                currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growth", new Object[]{growth}).func_150254_d());
            }
        } else {
            currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.not_growing", new Object[0]).func_150254_d());
        }
    }

    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockFruitTreeLeaves) {
            BlockFruitTreeLeaves block = (BlockFruitTreeLeaves)state.func_177230_c();
            if (((Boolean)state.func_177229_b((IProperty)BlockFruitTreeLeaves.HARVESTABLE)).booleanValue() && block.getTree().isHarvestMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear())) {
                if (state.func_177229_b(BlockFruitTreeLeaves.LEAF_STATE) != BlockFruitTreeLeaves.EnumLeafState.FRUIT) {
                    TETickCounter te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class);
                    FruitTreeProvider.addInfo(block.getTree(), te, ClimateTFC.getActualTemp(world, pos), ChunkDataTFC.getRainfall(world, pos), currentTooltip);
                }
            } else {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.agriculture.harvesting_months", new Object[0]).func_150254_d());
                for (Month month : Month.values()) {
                    if (!block.getTree().isHarvestMonth(month)) continue;
                    currentTooltip.add(TerraFirmaCraft.getProxy().getMonthName(month, true));
                }
            }
        } else if (state.func_177230_c() instanceof BlockFruitTreeSapling) {
            BlockFruitTreeSapling block = (BlockFruitTreeSapling)state.func_177230_c();
            TETickCounter te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class);
            FruitTreeProvider.addInfo(block.getTree(), te, ClimateTFC.getActualTemp(world, pos), ChunkDataTFC.getRainfall(world, pos), currentTooltip);
        } else if (state.func_177230_c() instanceof BlockFruitTreeTrunk) {
            IBlockState topMost = state;
            while (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFruitTreeTrunk) {
                pos = pos.func_177984_a();
                topMost = world.func_180495_p(pos);
            }
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockFruitTreeBranch) {
                return currentTooltip;
            }
            BlockFruitTreeTrunk block = (BlockFruitTreeTrunk)topMost.func_177230_c();
            TETickCounter te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class);
            FruitTreeProvider.addInfo(block.getTree(), te, ClimateTFC.getActualTemp(world, pos), ChunkDataTFC.getRainfall(world, pos), currentTooltip);
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return ImmutableList.of(BlockFruitTreeLeaves.class, BlockFruitTreeSapling.class, BlockFruitTreeTrunk.class);
    }
}

