/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.blocks.devices.BlockBloomery;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.TEBloom;
import net.dries007.tfc.objects.te.TEBloomery;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BloomeryProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ItemStack bloomStack;
        IForgeable forgeCap;
        TEBloom bloom;
        IItemHandler cap;
        ArrayList<String> currentTooltip = new ArrayList<String>();
        IBlockState state = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TEBloomery) {
            TEBloomery bloomery = (TEBloomery)tileEntity;
            if (((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
                ItemStack output;
                IForgeable cap2;
                ImmutableList<ItemStack> oreStacks = bloomery.getOreStacks();
                BloomeryRecipe recipe = oreStacks.size() > 0 ? BloomeryRecipe.get((ItemStack)oreStacks.get(0)) : null;
                long remainingTicks = bloomery.getRemainingTicks();
                switch (ConfigTFC.Client.TOOLTIP.timeTooltipMode) {
                    case NONE: {
                        break;
                    }
                    case TICKS: {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.devices.ticks_remaining", new Object[]{remainingTicks}).func_150254_d());
                        break;
                    }
                    case MINECRAFT_HOURS: {
                        long remainingHours = Math.round((float)remainingTicks / 1000.0f);
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.devices.hours_remaining", new Object[]{remainingHours}).func_150254_d());
                        break;
                    }
                    case REAL_MINUTES: {
                        long remainingMinutes = Math.round((float)remainingTicks / 1200.0f);
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.devices.minutes_remaining", new Object[]{remainingMinutes}).func_150254_d());
                    }
                }
                if (recipe != null && (cap2 = (IForgeable)(output = recipe.getOutput((List<ItemStack>)oreStacks)).getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null)) instanceof IForgeableMeasurableMetal) {
                    IForgeableMeasurableMetal forgeCap2 = (IForgeableMeasurableMetal)cap2;
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.bloomery.output", new Object[]{forgeCap2.getMetalAmount(), new TextComponentTranslation(forgeCap2.getMetal().getTranslationKey(), new Object[0]).func_150254_d()}).func_150254_d());
                }
            } else {
                int ores = bloomery.getOreStacks().size();
                int fuel = bloomery.getFuelStacks().size();
                int max = BlockBloomery.getChimneyLevels(world, bloomery.getInternalBlock()) * 8;
                currentTooltip.add(new TextComponentTranslation("waila.tfc.bloomery.ores", new Object[]{ores, max}).func_150254_d());
                currentTooltip.add(new TextComponentTranslation("waila.tfc.bloomery.fuel", new Object[]{fuel, max}).func_150254_d());
            }
        } else if (tileEntity instanceof TEBloom && (cap = (IItemHandler)(bloom = (TEBloom)tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && (forgeCap = (IForgeable)(bloomStack = cap.getStackInSlot(0)).getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null)) instanceof IForgeableMeasurableMetal) {
            IForgeableMeasurableMetal bloomCap = (IForgeableMeasurableMetal)forgeCap;
            currentTooltip.add(new TextComponentTranslation("waila.tfc.metal.output", new Object[]{bloomCap.getMetalAmount(), new TextComponentTranslation(bloomCap.getMetal().getTranslationKey(), new Object[0]).func_150254_d()}).func_150254_d());
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return ImmutableList.of(TEBloom.class, TEBloomery.class);
    }
}

