/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.te.TEBarrel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BarrelProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        TEBarrel te = Helpers.getTE((IBlockAccess)world, pos, TEBarrel.class);
        if (te != null) {
            FluidStack fluid;
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            FluidStack fluidStack = fluid = fluidHandler != null ? fluidHandler.drain(Integer.MAX_VALUE, false) : null;
            if (te.isSealed()) {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.barrel.sealed", new Object[]{te.getSealedDate()}).func_150254_d());
                BarrelRecipe recipe = te.getRecipe();
                if (recipe != null) {
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.barrel.recipe", new Object[]{recipe.getResultName()}).func_150254_d());
                } else {
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.barrel.no_recipe", new Object[0]).func_150254_d());
                }
            }
            if (fluid != null && fluid.amount > 0) {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.barrel.contents", new Object[]{fluid.amount, fluid.getLocalizedName()}).func_150254_d());
            }
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return Collections.singletonList(TEBarrel.class);
    }
}

