/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.compat.waila.interfaces.IWailaEntity;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.IShearable;

public class AnimalProvider
implements IWailaEntity {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull Entity entity, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        if (entity instanceof IAnimalTFC) {
            boolean familiarized;
            IAnimalTFC animal = (IAnimalTFC)entity;
            boolean bl = familiarized = animal.getFamiliarity() > 0.15f;
            if (animal.getAdultFamiliarityCap() > 0.0f) {
                currentTooltip.add(new TextComponentTranslation(familiarized ? "waila.tfc.animal.familiarized" : "waila.tfc.animal.not_familiarized", new Object[0]).func_150254_d());
            }
            switch (animal.getAge()) {
                case CHILD: {
                    long endPlayerTick = (animal.getBirthDay() + animal.getDaysToAdulthood()) * 24000;
                    long delta = endPlayerTick - CalendarTFC.PLAYER_TIME.getTicks();
                    long endCalendarTick = CalendarTFC.CALENDAR_TIME.getTicks() + delta;
                    String date = ICalendarFormatted.getTimeAndDate(endCalendarTick, CalendarTFC.CALENDAR_TIME.getDaysInMonth());
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.childhood_end", new Object[]{date}).func_150254_d());
                    break;
                }
                case OLD: {
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.old", new Object[0]).func_150254_d());
                }
                case ADULT: {
                    if (!familiarized) break;
                    if (animal.isReadyToMate()) {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.can_mate", new Object[0]).func_150254_d());
                    }
                    if (animal.isFertilized()) {
                        if (animal.getType() == IAnimalTFC.Type.MAMMAL) {
                            currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.pregnant", new Object[0]).func_150254_d());
                            if (animal instanceof EntityAnimalMammal) {
                                EntityAnimalMammal mother = (EntityAnimalMammal)animal;
                                long gestationDaysRemaining = mother.getPregnantTime() + mother.gestationDays() - CalendarTFC.PLAYER_TIME.getTotalDays();
                                currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.pregnant_end", new Object[]{gestationDaysRemaining}).func_150254_d());
                            }
                        } else {
                            currentTooltip.add(new TextComponentTranslation("tfc.tooltip.fertilized", new Object[0]).func_150254_d());
                        }
                    }
                    if (!animal.isReadyForAnimalProduct()) break;
                    if (animal instanceof IShearable) {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.can_shear", new Object[0]).func_150254_d());
                        break;
                    }
                    if (animal.getType() == IAnimalTFC.Type.OVIPAROUS) {
                        currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.has_eggs", new Object[0]).func_150254_d());
                        break;
                    }
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.animal.has_milk", new Object[0]).func_150254_d());
                }
            }
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return Collections.singletonList(IAnimalTFC.class);
    }
}

