/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.interfaces;

import java.util.List;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.dries007.tfc.compat.waila.interfaces.IWailaEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TOPEntityInterface
implements IProbeInfoEntityProvider,
IEntityDisplayOverride {
    protected final IWailaEntity internal;

    public TOPEntityInterface(IWailaEntity internal) {
        this.internal = internal;
    }

    public String getID() {
        return "top.tfc." + this.internal.getClass().getName();
    }

    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, Entity entity, IProbeHitEntityData hitData) {
        if (entity == null) {
            return;
        }
        if (!this.isLookingAtProvider(entity)) {
            return;
        }
        NBTTagCompound nbt = entity.func_189511_e(new NBTTagCompound());
        List<String> tooltip = this.internal.getTooltip(entity, nbt);
        for (String string : tooltip) {
            info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(string);
        }
    }

    public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, Entity entity, IProbeHitEntityData hitData) {
        if (entity == null) {
            return false;
        }
        if (!this.isLookingAtProvider(entity)) {
            return false;
        }
        NBTTagCompound nbt = entity.func_189511_e(new NBTTagCompound());
        String title = this.internal.getTitle(entity, nbt);
        if (title.isEmpty()) {
            return false;
        }
        info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).vertical().text(TextStyleClass.NAME + title).text(TextStyleClass.MODNAME + "TerraFirmaCraft");
        return true;
    }

    public boolean overridesHeadInfo() {
        return this.internal.overrideTitle();
    }

    protected boolean isLookingAtProvider(Entity entity) {
        for (Class<?> clazz : this.internal.getLookupClass()) {
            if (!clazz.isInstance(entity)) continue;
            return true;
        }
        return false;
    }
}

