/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.interfaces;

import java.util.List;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TOPBlockInterface
implements IProbeInfoProvider,
IBlockDisplayOverride {
    protected final IWailaBlock internal;

    public TOPBlockInterface(IWailaBlock internal) {
        this.internal = internal;
    }

    public String getID() {
        return "top.tfc." + this.internal.getClass().getName();
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, IBlockState state, IProbeHitData hitData) {
        BlockPos pos = hitData.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!this.isLookingAtProvider(state.func_177230_c(), tileEntity)) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        if (tileEntity != null) {
            nbt = tileEntity.func_189515_b(nbt);
        }
        List<String> tooltip = this.internal.getTooltip(world, hitData.getPos(), nbt);
        for (String string : tooltip) {
            info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(string);
        }
    }

    public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, IBlockState state, IProbeHitData hitData) {
        String title;
        ItemStack stack;
        BlockPos pos = hitData.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!this.isLookingAtProvider(state.func_177230_c(), tileEntity)) {
            return false;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        if (tileEntity != null) {
            nbt = tileEntity.func_189515_b(nbt);
        }
        ItemStack itemStack = stack = this.internal.overrideIcon() ? this.internal.getIcon(world, pos, nbt) : ItemStack.field_190927_a;
        if (stack.func_190926_b()) {
            stack = hitData.getPickBlock();
        }
        String string = title = this.internal.overrideTitle() ? this.internal.getTitle(world, pos, nbt) : "";
        if (title.isEmpty()) {
            info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(stack).vertical().itemLabel(stack).text(TextStyleClass.MODNAME + "TerraFirmaCraft");
        } else {
            info.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(stack).vertical().text(TextStyleClass.NAME + title).text(TextStyleClass.MODNAME + "TerraFirmaCraft");
        }
        return true;
    }

    public boolean overridesHeadInfo() {
        return this.internal.overrideIcon() || this.internal.overrideTitle();
    }

    protected boolean isLookingAtProvider(Block block, TileEntity tileEntity) {
        for (Class<?> clazz : this.internal.getLookupClass()) {
            if (!clazz.isInstance(block) && !clazz.isInstance(tileEntity)) continue;
            return true;
        }
        return false;
    }
}

