/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.interfaces;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class HwylaBlockInterface
implements IWailaDataProvider,
IWailaPlugin {
    protected final IWailaBlock internal;

    public HwylaBlockInterface(IWailaBlock internal) {
        this.internal = internal;
    }

    public void register(IWailaRegistrar registrar) {
        for (Class<?> clazz : this.internal.getLookupClass()) {
            registrar.registerBodyProvider((IWailaDataProvider)this, clazz);
            if (TileEntity.class.isAssignableFrom(clazz)) {
                registrar.registerNBTProvider((IWailaDataProvider)this, clazz);
            }
            if (this.internal.overrideTitle()) {
                registrar.registerHeadProvider((IWailaDataProvider)this, clazz);
            }
            if (!this.internal.overrideIcon()) continue;
            registrar.registerStackProvider((IWailaDataProvider)this, clazz);
        }
    }

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return this.internal.getIcon(accessor.getWorld(), accessor.getPosition(), accessor.getNBTData());
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currentTooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String title = this.internal.getTitle(accessor.getWorld(), accessor.getPosition(), accessor.getNBTData());
        if (!title.isEmpty()) {
            currentTooltip.clear();
            currentTooltip.add(TextFormatting.WHITE.toString() + title);
        }
        return currentTooltip;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currentTooltip.addAll(this.internal.getTooltip(accessor.getWorld(), accessor.getPosition(), accessor.getNBTData()));
        return currentTooltip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return te.func_189515_b(tag);
    }
}

