/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.compat.patchouli.KnappingComponent;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.VariableHolder;

public class RockKnappingComponent
extends KnappingComponent {
    @VariableHolder
    @SerializedName(value="rock")
    public String rockName;
    private transient ResourceLocation[] textures;
    private transient ItemStack[] stacks;

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        super.build(componentX, componentY, pageNum);
        Collection rocks = TFCRegistries.ROCKS.getValuesCollection();
        this.textures = new ResourceLocation[rocks.size()];
        this.stacks = new ItemStack[rocks.size()];
        int i = 0;
        for (Rock rock : rocks) {
            this.textures[i] = rock.getTexture();
            this.stacks[i] = ItemRock.get(rock, 1);
            ++i;
        }
    }

    @Override
    @Nullable
    protected ResourceLocation getSquareLow(int ticks) {
        return null;
    }

    @Override
    @Nullable
    protected ResourceLocation getSquareHigh(int ticks) {
        return this.textures[ticks / 20 % this.textures.length];
    }

    @Override
    @Nonnull
    protected ItemStack getInputItem(int ticks) {
        return this.stacks[ticks / 20 % this.stacks.length];
    }
}

