/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.compat.patchouli.CustomComponent;
import net.dries007.tfc.compat.patchouli.TFCPatchouliPlugin;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.book.gui.GuiBook;

public abstract class KnappingComponent
extends CustomComponent {
    @VariableHolder
    @SerializedName(value="recipe")
    public String recipeName;
    @Nullable
    protected transient KnappingRecipe recipe;

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        this.posX = componentX;
        this.posY = componentY;
        Objects.requireNonNull(this.recipeName, "Missing recipe name?");
        this.recipe = (KnappingRecipe)TFCRegistries.KNAPPING.getValue(new ResourceLocation(this.recipeName));
    }

    public void render(IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.getGui().field_146297_k.func_110434_K().func_110577_a(TFCPatchouliPlugin.BOOK_UTIL_TEXTURES);
        Gui.func_146110_a((int)this.posX, (int)this.posY, (float)0.0f, (float)0.0f, (int)116, (int)90, (float)256.0f, (float)256.0f);
        int ticks = context.getGui() instanceof GuiBook ? ((GuiBook)context.getGui()).ticksInBook : 0;
        ResourceLocation squareHigh = this.getSquareHigh(ticks);
        ResourceLocation squareLow = this.getSquareLow(ticks);
        if (this.recipe != null) {
            for (int y = 0; y < this.recipe.getMatrix().getHeight(); ++y) {
                for (int x = 0; x < this.recipe.getMatrix().getWidth(); ++x) {
                    if (this.recipe.getMatrix().get(x, y) && squareHigh != null) {
                        context.getGui().field_146297_k.func_110434_K().func_110577_a(squareHigh);
                        Gui.func_146110_a((int)(5 + x * 16), (int)(5 + y * 16), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                        continue;
                    }
                    if (squareLow == null) continue;
                    context.getGui().field_146297_k.func_110434_K().func_110577_a(squareLow);
                    Gui.func_146110_a((int)(5 + x * 16), (int)(5 + y * 16), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                }
            }
            context.renderItemStack(95, 37, mouseX, mouseY, this.recipe.getOutput(this.getInputItem(ticks)));
        } else {
            Gui.func_146110_a((int)92, (int)34, (float)2.0f, (float)144.0f, (int)22, (int)22, (float)256.0f, (float)256.0f);
            if (context.isAreaHovered(mouseX, mouseY, 92, 34, 22, 22)) {
                context.setHoverTooltip(Collections.singletonList(I18n.func_135052_a((String)"tfc.patchouli.recipe_removed", (Object[])new Object[0])));
            }
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 5; ++x) {
                    if (squareHigh == null) continue;
                    context.getGui().field_146297_k.func_110434_K().func_110577_a(squareHigh);
                    Gui.func_146110_a((int)(5 + x * 16), (int)(5 + y * 16), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    @Nullable
    protected abstract ResourceLocation getSquareLow(int var1);

    @Nullable
    protected abstract ResourceLocation getSquareHigh(int var1);

    @Nonnull
    protected ItemStack getInputItem(int ticks) {
        return ItemStack.field_190927_a;
    }
}

