/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ceramics.ItemMold;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class UnmoldRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack mold;
    private final ItemStack output;

    public UnmoldRecipeWrapper(Metal metal, Metal.ItemType type) {
        this.mold = new ItemStack((Item)ItemMold.get(type));
        IFluidHandler cap = (IFluidHandler)this.mold.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (cap instanceof IMoldHandler) {
            cap.fill(new FluidStack(FluidsTFC.getFluidFromMetal(metal), 100), true);
        }
        this.output = new ItemStack(ItemMetal.get(metal, type));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.mold);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }
}

