/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.metal.ItemOreTFC;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public class RockLayerWrapper
implements IRecipeWrapper {
    private final Rock rock;
    private final List<List<ItemStack>> oreList;

    public RockLayerWrapper(Rock rock) {
        this.rock = rock;
        this.oreList = new ArrayList<List<ItemStack>>();
        HashSet<Ore> ores = new HashSet<Ore>();
        ArrayList<IBlockState> customOres = new ArrayList<IBlockState>();
        for (VeinType vein : VeinRegistry.INSTANCE.getVeins().values()) {
            if (!vein.canSpawnIn(rock)) continue;
            if (vein.getOre() != null) {
                ores.add(vein.getOre());
                continue;
            }
            customOres.add(vein.getOreState(rock, Ore.Grade.NORMAL));
        }
        for (Ore ore : ores) {
            List oreItems = TFCRegistries.ROCKS.getValuesCollection().stream().map(r -> new ItemStack((Block)BlockOreTFC.get(ore, r))).collect(Collectors.toList());
            if (ore.isGraded()) {
                for (Ore.Grade grade : Ore.Grade.values()) {
                    oreItems.add(ItemOreTFC.get(ore, grade, 1));
                }
                oreItems.add(ItemSmallOre.get(ore, 1));
            } else {
                oreItems.add(ItemOreTFC.get(ore, 1));
            }
            this.oreList.add(oreItems);
        }
        if (customOres.size() > 0) {
            this.oreList.addAll(customOres.stream().filter(state -> state.func_185904_a() != Material.field_151579_a).map(state -> new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state))).map(Collections::singletonList).collect(Collectors.toList()));
        }
    }

    public void getIngredients(IIngredients recipeIngredients) {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        input.add(new ItemStack((Block)BlockRockVariant.get(this.rock, Rock.Type.RAW)));
        input.add(new ItemStack((Item)ItemRock.get(this.rock)));
        recipeIngredients.setInputs(VanillaTypes.ITEM, input);
        recipeIngredients.setOutputLists(VanillaTypes.ITEM, this.oreList);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int newLine = 11;
        float x = 33.0f;
        float y = 6.0f;
        String text = I18n.func_135052_a((String)"jei.tooltips.tfc.rock_layer.category", (Object[])new Object[0]);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 49920, false);
        text = I18n.func_135052_a((String)this.rock.getRockCategory().getTranslationKey(), (Object[])new Object[0]);
        List listString = minecraft.field_71466_p.func_78271_c(text, 64);
        for (String str : listString) {
            x = 33.0f;
            minecraft.field_71466_p.func_175065_a(str, x -= (float)minecraft.field_71466_p.func_78256_a(str) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        }
        x = 128.0f;
        y = 6.0f;
        text = I18n.func_135052_a((String)"jei.tooltips.tfc.rock_layer.layers", (Object[])new Object[0]);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 49920, false);
        if (RockCategory.Layer.TOP.test(this.rock)) {
            x = 128.0f;
            text = I18n.func_135052_a((String)"jei.tooltips.tfc.rock_layer.top", (Object[])new Object[0]);
            minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        }
        if (RockCategory.Layer.MIDDLE.test(this.rock)) {
            x = 128.0f;
            text = I18n.func_135052_a((String)"jei.tooltips.tfc.rock_layer.middle", (Object[])new Object[0]);
            minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        }
        if (RockCategory.Layer.BOTTOM.test(this.rock)) {
            x = 128.0f;
            text = I18n.func_135052_a((String)"jei.tooltips.tfc.rock_layer.bottom", (Object[])new Object[0]);
            minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        }
    }
}

