/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MetalHeatingRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack stack;
    private final FluidStack output;
    private final float meltingTemp;

    public MetalHeatingRecipeWrapper(ItemStack stack, Metal metal, int amount, float meltingTemp) {
        this.meltingTemp = meltingTemp;
        this.stack = stack;
        this.output = new FluidStack(FluidsTFC.getFluidFromMetal(metal), amount);
    }

    public void getIngredients(IIngredients recipeIngredients) {
        recipeIngredients.setInput(VanillaTypes.ITEM, (Object)this.stack);
        recipeIngredients.setOutput(VanillaTypes.FLUID, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float x = 60.0f;
        float y = 4.0f;
        String text = Heat.getTooltipAlternate(this.meltingTemp);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 0xFFFFFF, false);
    }
}

