/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class KnappingRecipeWrapper
implements IRecipeWrapper {
    private static final ResourceLocation CLAY_DISABLED_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button_disabled.png");
    private static final ResourceLocation FIRE_CLAY_DISABLED_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button_fire_disabled.png");
    private static final ResourceLocation CLAY_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button.png");
    private static final ResourceLocation FIRE_CLAY_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button_fire.png");
    private static final ResourceLocation LEATHER_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/leather_button.png");
    protected final KnappingRecipe recipe;
    private final IDrawable squareHigh;
    private final IDrawable squareLow;

    @Nullable
    private static ResourceLocation getHighTexture(KnappingType type) {
        if (type == KnappingType.CLAY) {
            return CLAY_TEXTURE;
        }
        if (type == KnappingType.FIRE_CLAY) {
            return FIRE_CLAY_TEXTURE;
        }
        if (type == KnappingType.LEATHER) {
            return LEATHER_TEXTURE;
        }
        return null;
    }

    @Nullable
    private static ResourceLocation getLowTexture(KnappingType type) {
        if (type == KnappingType.CLAY) {
            return CLAY_DISABLED_TEXTURE;
        }
        if (type == KnappingType.FIRE_CLAY) {
            return FIRE_CLAY_DISABLED_TEXTURE;
        }
        return null;
    }

    public KnappingRecipeWrapper(KnappingRecipe recipe, IGuiHelper guiHelper) {
        this(recipe, guiHelper, KnappingRecipeWrapper.getHighTexture(recipe.getType()), KnappingRecipeWrapper.getLowTexture(recipe.getType()));
    }

    protected KnappingRecipeWrapper(KnappingRecipe recipe, IGuiHelper helper, @Nullable ResourceLocation highTexture, @Nullable ResourceLocation lowTexture) {
        this.recipe = recipe;
        this.squareHigh = highTexture == null ? null : helper.drawableBuilder(highTexture, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.squareLow = lowTexture == null ? null : helper.drawableBuilder(lowTexture, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack output = this.recipe.getOutput(ItemStack.field_190927_a);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        for (int y = 0; y < this.recipe.getMatrix().getHeight(); ++y) {
            for (int x = 0; x < this.recipe.getMatrix().getWidth(); ++x) {
                if (this.recipe.getMatrix().get(x, y) && this.squareHigh != null) {
                    this.squareHigh.draw(minecraft, 1 + x * 16, 1 + y * 16);
                    continue;
                }
                if (this.squareLow == null) continue;
                this.squareLow.draw(minecraft, 1 + x * 16, 1 + y * 16);
            }
        }
    }

    public static class Stone
    extends KnappingRecipeWrapper {
        private final Rock rock;

        public Stone(KnappingRecipe recipe, IGuiHelper helper, Rock rock) {
            super(recipe, helper, rock.getTexture(), null);
            this.rock = rock;
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutputLists(VanillaTypes.ITEM, Helpers.listOf(Helpers.listOf(this.recipe.getOutput(new ItemStack((Item)ItemRock.get(this.rock))))));
        }
    }
}

