/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipeFluidMixing;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipeFoodPreservation;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipeFoodTraits;
import net.dries007.tfc.objects.inventory.ingredient.IngredientFluidItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class BarrelRecipeWrapper
implements IRecipeWrapper {
    private final BarrelRecipe recipe;
    private final List<ItemStack> itemIngredients;
    private final List<FluidStack> fluidIngredients;
    private final List<ItemStack> outputItems;
    private final FluidStack outputFluid;
    private final FluidStack inputFluid;

    public BarrelRecipeWrapper(BarrelRecipe recipe) {
        this.recipe = recipe;
        this.itemIngredients = recipe.getItemIngredient().getValidIngredients();
        this.fluidIngredients = recipe.getFluidIngredient().getValidIngredients();
        this.outputItems = new ArrayList<ItemStack>();
        this.outputFluid = recipe.getOutputFluid();
        if (recipe instanceof BarrelRecipeFoodTraits) {
            BarrelRecipeFoodTraits recipeFoodTraits = (BarrelRecipeFoodTraits)recipe;
            FluidStack fluid = this.fluidIngredients.size() > 0 ? this.fluidIngredients.get(0) : null;
            for (ItemStack ingredient : this.itemIngredients) {
                this.outputItems.addAll(recipeFoodTraits.getOutputItem(fluid, ingredient));
            }
            this.inputFluid = null;
        } else if (recipe instanceof BarrelRecipeFoodPreservation) {
            BarrelRecipeFoodPreservation recipePreservation = (BarrelRecipeFoodPreservation)recipe;
            FluidStack fluid = this.fluidIngredients.size() > 0 ? this.fluidIngredients.get(0) : null;
            for (ItemStack ingredient : this.itemIngredients) {
                recipePreservation.onBarrelSealed(fluid, ingredient);
                this.outputItems.add(ingredient);
            }
            this.inputFluid = null;
        } else if (recipe instanceof BarrelRecipeFluidMixing) {
            IngredientFluidItem ingredient = (IngredientFluidItem)recipe.getItemIngredient();
            this.inputFluid = ingredient.getFluid();
            int highestFluid = Math.max(this.inputFluid.amount, this.fluidIngredients.get((int)0).amount);
            if (this.outputFluid != null && highestFluid < this.outputFluid.amount) {
                highestFluid = this.outputFluid.amount;
            }
            double maximumMultiplier = (double)ConfigTFC.Devices.BARREL.tank / (double)highestFluid;
            double multiplier = Math.min(1000.0 / (double)this.inputFluid.amount, maximumMultiplier);
            this.inputFluid.amount = (int)((double)this.inputFluid.amount * multiplier);
            this.fluidIngredients.forEach(x -> {
                x.amount = (int)((double)x.amount * multiplier);
            });
            if (this.outputFluid != null) {
                this.outputFluid.amount = (int)((double)this.outputFluid.amount * multiplier);
            }
        } else {
            this.outputItems.add(recipe.getOutputStack());
            this.inputFluid = null;
        }
    }

    public void getIngredients(IIngredients ingredients) {
        if (this.isFluidMixing()) {
            ArrayList<List<FluidStack>> inputs = new ArrayList<List<FluidStack>>();
            inputs.add(this.fluidIngredients);
            inputs.add(Collections.singletonList(this.inputFluid));
            ingredients.setInputLists(VanillaTypes.FLUID, inputs);
        } else {
            ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.itemIngredients));
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(this.fluidIngredients));
        }
        if (this.outputItems.size() > 0) {
            ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(this.outputItems));
        }
        if (this.outputFluid != null) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.outputFluid);
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String text = this.recipe.getDuration() > 0 ? (this.recipe.getDuration() / 1000 < 25 ? I18n.func_135052_a((String)"jei.tooltips.tfc.barrel.duration.short", (Object[])new Object[]{this.recipe.getDuration() / 1000}) : I18n.func_135052_a((String)"jei.tooltips.tfc.barrel.duration", (Object[])new Object[]{this.recipe.getDuration() / 24000})) : I18n.func_135052_a((String)"jei.tooltips.tfc.barrel.instant", (Object[])new Object[0]);
        float x = 61.0f - (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f;
        float y = 46.0f;
        minecraft.field_71466_p.func_175065_a(text, x, y, 0, false);
    }

    public boolean isFluidMixing() {
        return this.inputFluid != null;
    }
}

