/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.recipes.AlloyRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AlloyRecipeWrapper
implements IRecipeWrapper {
    private final String[] slotContent = new String[]{"", "", "", ""};
    private final AlloyRecipe recipe;

    public AlloyRecipeWrapper(AlloyRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        int i = 0;
        ArrayList<ArrayList> allInputs = new ArrayList<ArrayList>();
        for (Metal metal : this.recipe.getMetals().keySet()) {
            int min = (int)(((AlloyRecipe.DoubleRange)this.recipe.getMetals().get((Object)metal)).getMin() * 100.0);
            int max = (int)(((AlloyRecipe.DoubleRange)this.recipe.getMetals().get((Object)metal)).getMax() * 100.0);
            this.slotContent[i] = min + "-" + max + "%";
            FluidStack fluidInput = new FluidStack(FluidsTFC.getFluidFromMetal(metal), 1000);
            allInputs.add(Lists.newArrayList((Object[])new FluidStack[]{fluidInput}));
            ++i;
        }
        ingredients.setInputLists(VanillaTypes.FLUID, allInputs);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack(FluidsTFC.getFluidFromMetal(this.recipe.getResult()), 1000));
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        for (int i = 0; i < 4; ++i) {
            int row = i / 2;
            int column = i % 2;
            float x = 20.0f + (float)column * 60.0f;
            float y = 17.0f + (float)row * 26.0f;
            String text = this.slotContent[i];
            minecraft.field_71466_p.func_175065_a(text, x, y, 0, false);
        }
    }
}

